package de.codecamp.messages.runtime;


import java.util.Locale;


/**
 * Converts message arguments from a type that is used in the application to a type that can be
 * handled by the used messsage format.
 */
@FunctionalInterface
public interface MessageArgConverter
{

  /**
   * Converts message arguments from a type that is used in the application to a type that can be
   * handled by the used messsage format.
   *
   * @param value
   *          the original value
   * @param locale
   *          the locale
   * @return the converted value
   */
  Object convert(Object value, Locale locale);

}
