/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.runtime;

import de.codecamp.messages.runtime.MessageArgConverter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;

public class DefaultMessageArgConverter
implements MessageArgConverter {
    @Override
    public Object convert(Object value, Locale locale, ZoneId timeZone) {
        if (value instanceof LocalDate) {
            return Date.from(((LocalDate)value).atStartOfDay(timeZone).toInstant());
        }
        if (value instanceof LocalTime) {
            return Date.from(((LocalTime)value).atDate(LocalDate.now(timeZone)).atZone(timeZone).toInstant());
        }
        if (value instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)value).atZone(timeZone).toInstant());
        }
        if (value instanceof ZonedDateTime) {
            return Date.from(((ZonedDateTime)value).toInstant());
        }
        if (value instanceof OffsetTime) {
            ZoneId zoneId = timeZone;
            return Date.from(((OffsetTime)value).atDate(LocalDate.now(zoneId)).atZoneSameInstant(zoneId).toInstant());
        }
        if (value instanceof OffsetDateTime) {
            return Date.from(((OffsetDateTime)value).atZoneSameInstant(timeZone).toInstant());
        }
        if (value instanceof Instant) {
            return Date.from(((Instant)value).atZone(timeZone).toInstant());
        }
        return value;
    }
}

