/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.runtime;

import com.ibm.icu.util.TimeZone;
import de.codecamp.messages.runtime.MessageArgConverter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;

public class IcuMessageArgConverter
implements MessageArgConverter {
    @Override
    public Object convert(Object value, Locale locale, ZoneId timeZone) {
        Calendar calendar;
        ZonedDateTime zonedDateTime = null;
        if (value instanceof Calendar) {
            calendar = (Calendar)value;
            zonedDateTime = ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        } else if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            zonedDateTime = localDate.atStartOfDay(timeZone);
        } else if (value instanceof LocalTime) {
            LocalTime localTime = (LocalTime)value;
            zonedDateTime = localTime.atDate(LocalDate.now(timeZone)).atZone(timeZone);
        } else if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            zonedDateTime = localDateTime.atZone(timeZone);
        } else if (value instanceof ZonedDateTime) {
            zonedDateTime = (ZonedDateTime)value;
        } else if (value instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)value;
            zonedDateTime = offsetTime.atDate(LocalDate.now(offsetTime.getOffset())).toZonedDateTime();
        } else if (value instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)value;
            zonedDateTime = offsetDateTime.toZonedDateTime();
        } else if (value instanceof Instant) {
            Instant instant = (Instant)value;
            zonedDateTime = instant.atZone(timeZone);
        }
        if (zonedDateTime != null) {
            calendar = com.ibm.icu.util.Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)zonedDateTime.getZone().getId()));
            calendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
            return calendar;
        }
        return value;
    }
}

