/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.processor;

import de.codecamp.messages.MessageKeyUtils;
import de.codecamp.messages.MessageKeyWithArgs;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.apache.commons.lang3.ArrayUtils;

public class ProcessedMessageKey
implements MessageKeyWithArgs,
Comparable<ProcessedMessageKey> {
    private final Element sourceElement;
    private final TypeElement owningTypeElement;
    private final String prefix;
    private final String localPart;
    private final String[] argTypes;
    private final String[] argNames;

    public ProcessedMessageKey(Element sourceElement, TypeElement owningTypeElement, String prefix, String localPart, String[] argTypes, String[] argNames) {
        Objects.requireNonNull(sourceElement, "sourceElement must not be null");
        Objects.requireNonNull(prefix, "prefix must not be null");
        Objects.requireNonNull(localPart, "localPart must not be null");
        this.sourceElement = sourceElement;
        this.owningTypeElement = owningTypeElement;
        this.prefix = prefix;
        this.localPart = localPart;
        this.argTypes = argTypes;
        this.argNames = argNames;
    }

    public Element getSourceElement() {
        return this.sourceElement;
    }

    public TypeElement getOwningTypeElement() {
        return this.owningTypeElement;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getCode() {
        return MessageKeyUtils.getKeyFor((String)this.prefix, (String)this.localPart);
    }

    public boolean hasArgs() {
        return ArrayUtils.isNotEmpty((Object[])this.argTypes);
    }

    public int getArgCount() {
        if (!this.hasArgs()) {
            return 0;
        }
        return this.argTypes.length;
    }

    public String[] getArgTypes() {
        return this.argTypes;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    @Override
    public int compareTo(ProcessedMessageKey o) {
        return this.toString().compareTo(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProcessedMessageKey)) {
            return false;
        }
        ProcessedMessageKey other = (ProcessedMessageKey)obj;
        return other.getPrefix().equals(this.getPrefix()) && Objects.equals(other.getLocalPart(), this.getLocalPart());
    }

    public String toString() {
        return this.getCode();
    }
}

