/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.processor;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class LangModelUtils {
    private static final Set<String> BEAN_PROPERTY_GETTER_PREFIXES = new HashSet<String>(Arrays.asList("get", "is"));
    private static final Set<String> IGNORED_BEAN_PROPERTIES = new HashSet<String>(Arrays.asList("class"));

    public static Optional<TypeElement> getSuperclassType(TypeElement type) {
        TypeMirror superclassTypeMirror = type.getSuperclass();
        if (superclassTypeMirror.getKind() == TypeKind.NONE) {
            return Optional.empty();
        }
        return Optional.ofNullable((TypeElement)((DeclaredType)superclassTypeMirror).asElement());
    }

    public static List<TypeElement> getInterfaceTypes(TypeElement type) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        for (TypeMirror typeMirror : type.getInterfaces()) {
            result.add((TypeElement)((DeclaredType)typeMirror).asElement());
        }
        return result;
    }

    public static List<TypeElement> getTypeNesting(TypeElement typeElement) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        while (typeElement != null) {
            result.add(0, typeElement);
            typeElement = LangModelUtils.getEnclosingTypeElement(typeElement);
        }
        return result;
    }

    public static TypeElement getEnclosingTypeElement(Element element) {
        while ((element = element.getEnclosingElement()) != null && !element.getKind().isClass() && !element.getKind().isInterface()) {
        }
        return (TypeElement)element;
    }

    public static PackageElement getPackage(Element element) {
        while (element != null && element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    public static List<VariableElement> getDeclaredFields(TypeElement element) {
        return ElementFilter.fieldsIn(element.getEnclosedElements());
    }

    public static List<ExecutableElement> getDeclaredMethods(TypeElement element) {
        return ElementFilter.methodsIn(element.getEnclosedElements());
    }

    public static List<VariableElement> getEnumConstants(TypeElement enumTypeElement) {
        if (enumTypeElement.getKind() != ElementKind.ENUM) {
            throw new IllegalArgumentException("not an enum: " + enumTypeElement.getQualifiedName());
        }
        return ElementFilter.fieldsIn(enumTypeElement.getEnclosedElements()).stream().filter(ve -> ve.getKind() == ElementKind.ENUM_CONSTANT).collect(Collectors.toList());
    }

    public static Map<String, ExecutableElement> findDeclaredBeanProperties(TypeElement beanTypeElement) {
        HashMap<String, ExecutableElement> properties = new HashMap<String, ExecutableElement>();
        for (ExecutableElement methodElement : LangModelUtils.getDeclaredMethods(beanTypeElement)) {
            if (!methodElement.getModifiers().contains((Object)Modifier.PUBLIC) || methodElement.getModifiers().contains((Object)Modifier.STATIC) || methodElement.getReturnType().getKind() == TypeKind.VOID || !methodElement.getParameters().isEmpty()) continue;
            String methodName = methodElement.getSimpleName().toString();
            String propertyName = null;
            for (String prefix : BEAN_PROPERTY_GETTER_PREFIXES) {
                if (!methodName.startsWith(prefix)) continue;
                propertyName = methodName.substring(prefix.length());
                propertyName = Introspector.decapitalize(propertyName);
                break;
            }
            if (propertyName == null || IGNORED_BEAN_PROPERTIES.contains(propertyName)) continue;
            properties.put(propertyName, methodElement);
        }
        return properties;
    }

    public static <A extends Annotation> Optional<A> findFirstMetaAnnotation(Element element, Class<A> metaAnnotationType) {
        List<A> metaAnnotations = LangModelUtils.findMetaAnnotations(element, metaAnnotationType);
        if (!metaAnnotations.isEmpty()) {
            return Optional.of((Annotation)metaAnnotations.get(0));
        }
        return Optional.empty();
    }

    public static <A extends Annotation> List<A> findMetaAnnotations(Element element, Class<A> metaAnnotationType) {
        ArrayList<A> result = new ArrayList<A>();
        A annotation = element.getAnnotation(metaAnnotationType);
        if (annotation != null) {
            result.add(annotation);
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            annotation = annotationMirror.getAnnotationType().asElement().getAnnotation(metaAnnotationType);
            if (annotation == null) continue;
            result.add(annotation);
        }
        return result;
    }

    public static AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annotationType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationType.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static Set<AnnotationMirror> getAnnotationMirrors(Element element, Class<? extends Annotation> annotationType) {
        Class<? extends Annotation> containerAnnotationType = null;
        Repeatable repeatableAt = annotationType.getAnnotation(Repeatable.class);
        if (repeatableAt != null) {
            containerAnnotationType = repeatableAt.value();
        }
        HashSet<AnnotationMirror> result = new HashSet<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (containerAnnotationType != null && annotationMirror.getAnnotationType().toString().equals(containerAnnotationType.getCanonicalName())) {
                result.addAll(LangModelUtils.getAnnotationValueAsAnnotationMirrors(annotationMirror, "value"));
                continue;
            }
            if (!annotationMirror.getAnnotationType().toString().equals(annotationType.getName())) continue;
            result.add(annotationMirror);
        }
        return result;
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            AnnotationValue value = entry.getValue();
            if (value == null) {
                value = entry.getKey().getDefaultValue();
            }
            return value;
        }
        return null;
    }

    public static <T> T getAnnotationValueAs(AnnotationMirror annotationMirror, String key, Class<T> type, T defaultValue) {
        AnnotationValue annotationValue = LangModelUtils.getAnnotationValue(annotationMirror, key);
        Object value = annotationValue != null ? annotationValue.getValue() : defaultValue;
        return type.cast(value);
    }

    public static <T> List<T> getAnnotationValuesAs(AnnotationMirror annotationMirror, String key, Class<T> type, List<T> defaultValue) {
        AnnotationValue annotationValue = LangModelUtils.getAnnotationValue(annotationMirror, key);
        List<Object> values = new ArrayList();
        if (annotationValue != null) {
            List annotationValueList = (List)annotationValue.getValue();
            for (AnnotationValue annotationValueListElement : annotationValueList) {
                values.add(type.cast(annotationValueListElement.getValue()));
            }
        } else {
            values = defaultValue;
        }
        return values;
    }

    public static <T> List<T> getAnnotationValuesAs(AnnotationMirror annotationMirror, String key, Class<T> listElementType) {
        List<AnnotationValue> annotationValues = LangModelUtils.getAnnotationValues(annotationMirror, key);
        if (annotationValues == null) {
            return null;
        }
        return annotationValues.stream().map(av -> listElementType.cast(av.getValue())).collect(Collectors.toList());
    }

    public static List<AnnotationValue> getAnnotationValues(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            AnnotationValue annotationValue = LangModelUtils.getAnnotationValue(annotationMirror, key);
            return (List)annotationValue.getValue();
        }
        return Collections.emptyList();
    }

    public static TypeElement getAnnotationValueAsType(AnnotationMirror annotationMirror, String key) {
        AnnotationValue annotationValue = LangModelUtils.getAnnotationValue(annotationMirror, key);
        if (annotationValue == null) {
            return null;
        }
        DeclaredType typeMirror = (DeclaredType)annotationValue.getValue();
        if (typeMirror == null) {
            return null;
        }
        return (TypeElement)typeMirror.asElement();
    }

    public static List<TypeElement> getAnnotationValueAsTypes(AnnotationMirror annotationMirror, String key) {
        List<AnnotationValue> values = LangModelUtils.getAnnotationValues(annotationMirror, key);
        if (values == null) {
            return null;
        }
        return values.stream().map(av -> (TypeElement)((DeclaredType)av.getValue()).asElement()).collect(Collectors.toList());
    }

    public static List<AnnotationMirror> getAnnotationValueAsAnnotationMirrors(AnnotationMirror annotationMirror, String key) {
        List<AnnotationValue> values = LangModelUtils.getAnnotationValues(annotationMirror, key);
        if (values == null) {
            return null;
        }
        return values.stream().map(av -> (AnnotationMirror)av.getValue()).collect(Collectors.toList());
    }

    public static <A extends TypeElement> Set<A> findComposedAnnotationTypes(Set<A> processedAnnotations, Class<? extends Annotation> metaAnnotationType, boolean includeMetaAnnotation) {
        HashSet<TypeElement> annotations = new HashSet<TypeElement>();
        for (TypeElement annotationElement : processedAnnotations) {
            if ((!includeMetaAnnotation || !annotationElement.getQualifiedName().toString().equals(metaAnnotationType.getName())) && annotationElement.getAnnotation(metaAnnotationType) == null) continue;
            annotations.add(annotationElement);
        }
        return annotations;
    }
}

