/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.processor;

import com.google.auto.service.AutoService;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import de.codecamp.messages.MessageKey;
import de.codecamp.messages.MessageKeyWithArgs;
import de.codecamp.messages.Messages;
import de.codecamp.messages.MessagesFor;
import de.codecamp.messages.codegen.MessageCodegenUtils;
import de.codecamp.messages.processor.LangModelUtils;
import de.codecamp.messages.processor.MessageKeyConstantsFileBuilder;
import de.codecamp.messages.processor.MessageProxyFileBuilder;
import de.codecamp.messages.processor.ProcessedMessageKey;
import de.codecamp.messages.processor.ProcessorUtils;
import de.codecamp.messages.shared.bundle.BundleException;
import de.codecamp.messages.shared.bundle.BundleFile;
import de.codecamp.messages.shared.bundle.MessageBundleManager;
import de.codecamp.messages.shared.conf.BundleMismatchPolicy;
import de.codecamp.messages.shared.conf.MessageArgPolicy;
import de.codecamp.messages.shared.conf.MissingMessagePolicy;
import de.codecamp.messages.shared.conf.ProjectConf;
import de.codecamp.messages.shared.conf.ProjectConfException;
import de.codecamp.messages.shared.conf.UndeclaredKeyPolicy;
import de.codecamp.messages.shared.messageformat.MessageFormatSupport;
import de.codecamp.messages.shared.model.AbstractPersistableData;
import de.codecamp.messages.shared.model.MessageKeyIndex;
import de.codecamp.messages.shared.model.MessageKeyWithSourceLocation;
import de.codecamp.messages.shared.model.MessageModule;
import de.codecamp.messages.shared.validation.MessageValidationUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

@AutoService(value={Processor.class})
public class MessageKeyProcessor
extends AbstractProcessor {
    public static final String OPT_SKIP = "messages.skip";
    private static final Map<String, String> DEFAULT_TYPE_ABBREVIATIONS = new HashMap<String, String>();
    private static final Map<String, PrimitiveType> PRIMITIVE_TYPES;
    private static final Logger LOG;
    private ProcessorUtils utils;
    private ProjectConf projectConf;
    private boolean dontProcess = false;
    private boolean messageKeysIncomplete = false;
    private boolean importsLoaded = true;
    private MessageBundleManager<Path, Path> messageBundleManager;
    private Set<TypeElement> processedTypes = new HashSet<TypeElement>();
    private Set<String> withMessageConstants = new HashSet<String>();
    private Set<String> withMessageProxies = new HashSet<String>();
    private Set<ExecutableElement> skipAsMethod = new HashSet<ExecutableElement>();
    private Map<TypeElement, Boolean> foundMessageForTypes = new HashMap<TypeElement, Boolean>();
    private SetMultimap<TypeElement, ProcessedMessageKey> messageKeysPerType = LinkedHashMultimap.create();
    private Map<String, ProcessedMessageKey> processedMessageKeys = new HashMap<String, ProcessedMessageKey>();
    private SetMultimap<Locale, MessageKey> messagesInProject;
    private MessageKeyIndex messageKeysInProject;
    private Map<String, MessageKeyIndex> importedMessageKeysPerModule = new HashMap<String, MessageKeyIndex>();
    private MessageFormatSupport messageFormatSupport;
    private boolean cleanBuild;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Stream.concat(Stream.of(OPT_SKIP), ProjectConf.ALL_CONF_NAMES.stream()).collect(Collectors.toSet());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.utils = new ProcessorUtils(processingEnv);
        boolean skip = this.utils.getOptionAsBoolean(OPT_SKIP, false);
        if (skip) {
            this.dontProcess = true;
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Skipping MessageKeyProcessor.");
            return;
        }
        try {
            this.projectConf = new ProjectConf(this.utils::getOption);
        }
        catch (ProjectConfException ex) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
            this.dontProcess = true;
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement classElement;
        if (this.dontProcess) {
            return false;
        }
        Set<? extends Element> elementsWithMessagesFor = ProcessorUtils.getElementsAnnotatedWith(roundEnv, MessagesFor.class);
        for (Element element : elementsWithMessagesFor) {
            Set<AnnotationMirror> set = LangModelUtils.getAnnotationMirrors(element, MessagesFor.class);
            for (AnnotationMirror annotationMirror : set) {
                classElement = LangModelUtils.getAnnotationValueAsType(annotationMirror, "type");
                boolean forProperties = LangModelUtils.getAnnotationValueAs(annotationMirror, "forProperties", Boolean.class, false);
                this.foundMessageForTypes.put(classElement, forProperties);
            }
        }
        for (Element element : elementsWithMessagesFor) {
            Set<AnnotationMirror> set = LangModelUtils.getAnnotationMirrors(element, MessagesFor.class);
            for (AnnotationMirror annotationMirror : set) {
                classElement = LangModelUtils.getAnnotationValueAsType(annotationMirror, "type");
                this.processType(classElement, annotationMirror);
            }
        }
        Set<? extends TypeElement> composedMessagesAnnotations = LangModelUtils.findComposedAnnotationTypes(annotations, Messages.class, true);
        for (TypeElement typeElement : composedMessagesAnnotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (element.getKind() == ElementKind.ANNOTATION_TYPE) continue;
                if (element.getKind().isClass() || element.getKind().isInterface()) {
                    this.processType((TypeElement)element, null);
                    continue;
                }
                if (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.ENUM_CONSTANT) {
                    TypeElement typeElement2 = LangModelUtils.getEnclosingTypeElement(element);
                    this.processType(typeElement2, null);
                    continue;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "unsupported element", element);
            }
        }
        if (roundEnv.processingOver() && !this.processedTypes.isEmpty()) {
            boolean bl = this.updateMessageKeyIndex();
            if (bl) {
                this.checkUnmappedKeys();
                this.processBundleFiles();
            }
            this.processedTypes.clear();
        }
        return false;
    }

    protected void processType(TypeElement typeElement, AnnotationMirror messagesForAt) {
        String msg;
        boolean forProperties;
        boolean forType;
        if (this.processedTypes.contains(typeElement)) {
            return;
        }
        this.processedTypes.add(typeElement);
        TypeElement generatedTypeElement = ProcessorUtils.getGeneratedAnnotation(this.processingEnv.getElementUtils(), this.processingEnv.getSourceVersion());
        ClassName generatedClassName = null;
        if (generatedTypeElement != null) {
            generatedClassName = ClassName.get((TypeElement)generatedTypeElement);
        }
        String defaultCodegenPackageName = LangModelUtils.getPackage(typeElement).getQualifiedName().toString();
        String codegenPackageName = null;
        if (messagesForAt != null) {
            codegenPackageName = LangModelUtils.getAnnotationValueAs(messagesForAt, "targetPackage", String.class, null);
            if (Objects.equals(codegenPackageName, "__DEFAULT__")) {
                codegenPackageName = null;
            }
            if (codegenPackageName == null) {
                codegenPackageName = this.projectConf.toTargetForExternalPackage(defaultCodegenPackageName);
            }
            if (defaultCodegenPackageName.equals(codegenPackageName)) {
                String msg2 = "Message key related code generated for the external type should be mapped to a local package to avoid split packages.";
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg2, typeElement, messagesForAt);
            }
        }
        if (codegenPackageName == null) {
            codegenPackageName = defaultCodegenPackageName;
        }
        MessageKeyConstantsFileBuilder constantsBuilder = null;
        if (this.projectConf.getGenerateConstants()) {
            constantsBuilder = new MessageKeyConstantsFileBuilder(typeElement, generatedClassName, codegenPackageName);
        }
        MessageProxyFileBuilder proxyBuilder = null;
        if (this.projectConf.getGenerateProxies()) {
            proxyBuilder = new MessageProxyFileBuilder(typeElement, generatedClassName, codegenPackageName);
        }
        String prefix = null;
        HashSet<String> ignoreImplicitKeys = null;
        List<Messages> classMsgsAt = LangModelUtils.findMetaAnnotations(typeElement, Messages.class);
        boolean hasMessageAtOnType = !classMsgsAt.isEmpty();
        LinkedHashSet<String> localParts = new LinkedHashSet<String>();
        if (!classMsgsAt.isEmpty()) {
            prefix = classMsgsAt.stream().map(Messages::prefix).filter(p -> !p.equals("__SOURCE_TYPE__")).findFirst().orElse(null);
            forType = classMsgsAt.stream().anyMatch(m -> m.forType());
            forProperties = classMsgsAt.stream().anyMatch(m -> m.forProperties());
            for (Messages msgsAt : classMsgsAt) {
                localParts.addAll(Arrays.asList(msgsAt.keys()));
                localParts.addAll(Arrays.asList(msgsAt.value()));
            }
        } else if (messagesForAt != null) {
            hasMessageAtOnType = true;
            forType = LangModelUtils.getAnnotationValueAs(messagesForAt, "forType", Boolean.class, false);
            forProperties = LangModelUtils.getAnnotationValueAs(messagesForAt, "forProperties", Boolean.class, false);
            List<String> ignoreImplicitKeysList = LangModelUtils.getAnnotationValuesAs(messagesForAt, "ignoreImplicitKeys", String.class, Collections.emptyList());
            ignoreImplicitKeys = new HashSet<String>(ignoreImplicitKeysList);
            prefix = LangModelUtils.getAnnotationValueAs(messagesForAt, "prefix", String.class, "__SOURCE_TYPE__");
            localParts.addAll(LangModelUtils.getAnnotationValuesAs(messagesForAt, "keys", String.class));
            localParts.addAll(LangModelUtils.getAnnotationValuesAs(messagesForAt, "value", String.class));
        } else {
            forType = false;
            forProperties = false;
        }
        if (prefix == null || prefix.equals("__SOURCE_TYPE__")) {
            prefix = typeElement.getQualifiedName().toString() + ".";
        }
        if (localParts.remove("")) {
            forType = true;
        }
        if (forType) {
            this.addMsgKey(typeElement, typeElement, prefix, "Type");
        }
        this.addMsgKeys(typeElement, typeElement, prefix, localParts);
        if (hasMessageAtOnType) {
            List<VariableElement> enumConstants = this.processEnum(prefix, typeElement, ignoreImplicitKeys);
            if (constantsBuilder != null && enumConstants != null) {
                MethodSpec.Builder forEnumMethodBuilder = MethodSpec.methodBuilder((String)"forEnum").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)ClassName.get((TypeElement)typeElement), "element", new Modifier[0]).returns(MessageKey.class);
                forEnumMethodBuilder.beginControlFlow("switch (element)", new Object[0]);
                for (VariableElement enumConstant : enumConstants) {
                    forEnumMethodBuilder.addCode("case $L:\n", new Object[]{enumConstant.getSimpleName()});
                    forEnumMethodBuilder.addStatement("$>return $L", new Object[]{enumConstant.getSimpleName()});
                    forEnumMethodBuilder.addCode("$<", new Object[0]);
                }
                forEnumMethodBuilder.addCode("default:\n", new Object[0]);
                forEnumMethodBuilder.addCode("$>", new Object[0]);
                forEnumMethodBuilder.addStatement("String msg = $S", new Object[]{"Element %s for enum %s unknown. %s probably needs to be regenerated."});
                forEnumMethodBuilder.addStatement("msg = String.format(msg, element.name(), $T.class.getName(), $L.class.getName());", new Object[]{typeElement, constantsBuilder.getConstantsSimpleTypeName()});
                forEnumMethodBuilder.addStatement("throw new IllegalStateException(msg)", new Object[0]);
                forEnumMethodBuilder.endControlFlow();
                constantsBuilder.getTypeSpecBuilder().addMethod(forEnumMethodBuilder.build());
            }
        }
        if (forProperties) {
            this.processProperties(prefix, typeElement, null, ignoreImplicitKeys, false);
        }
        this.processFields(prefix, typeElement, hasMessageAtOnType);
        this.processMethods(prefix, typeElement);
        ArrayDeque inheritedMessageTypeElementsQueue = new ArrayDeque();
        LangModelUtils.getSuperclassType(typeElement).ifPresent(type -> inheritedMessageTypeElementsQueue.addLast(Pair.of((Object)type, (Object)true)));
        LangModelUtils.getInterfaceTypes(typeElement).forEach(type -> inheritedMessageTypeElementsQueue.addLast(Pair.of((Object)type, (Object)true)));
        while (!inheritedMessageTypeElementsQueue.isEmpty()) {
            Pair pair = (Pair)inheritedMessageTypeElementsQueue.pop();
            TypeElement inheritedTypeElement = (TypeElement)pair.getLeft();
            boolean extendConstants = (Boolean)pair.getRight();
            boolean inheritedTypeHasMessages = false;
            boolean inheritedTypeForProperties = false;
            List<Messages> messagesAts = LangModelUtils.findMetaAnnotations(inheritedTypeElement, Messages.class);
            if (!messagesAts.isEmpty()) {
                inheritedTypeHasMessages = true;
                for (Messages messagesAt : messagesAts) {
                    if (!messagesAt.forProperties()) continue;
                    inheritedTypeForProperties = true;
                    break;
                }
            }
            if (!inheritedTypeHasMessages) {
                for (VariableElement fieldElement : LangModelUtils.getDeclaredFields(inheritedTypeElement)) {
                    if (!LangModelUtils.findFirstMetaAnnotation(fieldElement, Messages.class).isPresent()) continue;
                    inheritedTypeHasMessages = true;
                    break;
                }
            }
            if (!inheritedTypeHasMessages) {
                for (ExecutableElement methodElement : LangModelUtils.getDeclaredMethods(inheritedTypeElement)) {
                    if (!LangModelUtils.findFirstMetaAnnotation(methodElement, Messages.class).isPresent()) continue;
                    inheritedTypeHasMessages = true;
                    break;
                }
            }
            if (inheritedTypeHasMessages || this.foundMessageForTypes.containsKey(inheritedTypeElement) || this.hasMessageConstants(inheritedTypeElement)) {
                if (extendConstants) {
                    extendConstants = false;
                    if (constantsBuilder != null) {
                        constantsBuilder.getTypeSpecBuilder().addSuperinterface((TypeName)MessageKeyProcessor.getMessageConstantsClassName(inheritedTypeElement));
                    }
                    if (proxyBuilder != null && this.hasMessageProxies(inheritedTypeElement)) {
                        proxyBuilder.getTypeSpecBuilder().addSuperinterface((TypeName)MessageKeyProcessor.getMessageProxiesClassName(inheritedTypeElement));
                    }
                }
                if (!forProperties || inheritedTypeForProperties || this.foundMessageForTypes.getOrDefault(inheritedTypeElement, false).booleanValue()) continue;
                this.processProperties(prefix, inheritedTypeElement, typeElement, ignoreImplicitKeys, true);
            } else if (forProperties) {
                this.processProperties(prefix, inheritedTypeElement, typeElement, ignoreImplicitKeys, true);
            }
            boolean finalExtendConstants = extendConstants;
            LangModelUtils.getSuperclassType(inheritedTypeElement).ifPresent(type -> inheritedMessageTypeElementsQueue.addLast(Pair.of((Object)type, (Object)finalExtendConstants)));
            LangModelUtils.getInterfaceTypes(inheritedTypeElement).forEach(type -> inheritedMessageTypeElementsQueue.addLast(Pair.of((Object)type, (Object)finalExtendConstants)));
        }
        for (ProcessedMessageKey key : this.getMsgKeys(typeElement)) {
            if (constantsBuilder != null) {
                constantsBuilder.addMessageKey(key.getLocalPart(), key.getCode(), key.getArgTypes(), key.getArgNames());
            }
            if (proxyBuilder == null) continue;
            proxyBuilder.addMessageMethod(key.getLocalPart(), key.getCode(), key.getArgTypes(), key.getArgNames());
        }
        if (constantsBuilder != null) {
            try {
                constantsBuilder.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException ex) {
                msg = String.format("Failed to write the message key constants for %s.", typeElement.getQualifiedName());
                LOG.log(Level.SEVERE, msg, ex);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, typeElement);
            }
        }
        if (proxyBuilder != null) {
            try {
                proxyBuilder.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException ex) {
                msg = String.format("Failed to write the message proxy for %s.", typeElement.getQualifiedName());
                LOG.log(Level.SEVERE, msg, ex);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, typeElement);
            }
        }
    }

    private List<VariableElement> processEnum(String prefix, TypeElement typeElement, Set<String> ignoredElements) {
        if (typeElement.getKind() == ElementKind.ENUM) {
            ArrayList<VariableElement> processedEnumConstants = new ArrayList<VariableElement>();
            for (VariableElement enumConstant : LangModelUtils.getEnumConstants(typeElement)) {
                if (ignoredElements != null && ignoredElements.contains(enumConstant.getSimpleName().toString())) continue;
                List<Messages> enumElemMsgsAt = LangModelUtils.findMetaAnnotations(enumConstant, Messages.class);
                if (!enumElemMsgsAt.isEmpty()) {
                    if (enumElemMsgsAt.get(0).ignoreImplicit()) continue;
                    for (Messages msgsAt : enumElemMsgsAt) {
                        this.addMsgKeys(enumConstant, typeElement, prefix, enumConstant.getSimpleName().toString(), Arrays.asList(msgsAt.keys()));
                        this.addMsgKeys(enumConstant, typeElement, prefix, enumConstant.getSimpleName().toString(), Arrays.asList(msgsAt.value()));
                    }
                }
                this.addMsgKey(enumConstant, typeElement, prefix, enumConstant.getSimpleName().toString());
                processedEnumConstants.add(enumConstant);
            }
            return processedEnumConstants;
        }
        return null;
    }

    private void processProperties(String prefix, TypeElement typeElement, TypeElement incorporatingTypeElement, Set<String> ignoredProperties, boolean skipDuplicates) {
        if (incorporatingTypeElement == null) {
            incorporatingTypeElement = typeElement;
        }
        for (Map.Entry<String, ExecutableElement> property : LangModelUtils.findDeclaredBeanProperties(typeElement).entrySet()) {
            ExecutableElement getterMethodElement = property.getValue();
            this.skipAsMethod.add(getterMethodElement);
            String propertyName = property.getKey();
            if (ignoredProperties != null && ignoredProperties.contains(propertyName)) continue;
            List<Messages> propertyMsgsAts = LangModelUtils.findMetaAnnotations(getterMethodElement, Messages.class);
            boolean ignoreImplicit = false;
            Messages messagesAt = getterMethodElement.getAnnotation(Messages.class);
            if (messagesAt != null) {
                ignoreImplicit = messagesAt.ignoreImplicit();
            }
            if (getterMethodElement.getAnnotation(Override.class) != null) {
                ignoreImplicit = true;
            }
            HashSet<String> propertyKeys = new HashSet<String>();
            for (Messages msgsAt : propertyMsgsAts) {
                if (!msgsAt.prefix().equals("__SOURCE_TYPE__")) {
                    String msg = "Prefix only allowed on type level.";
                    msg = String.format(msg, new Object[0]);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, getterMethodElement);
                }
                propertyKeys.addAll(Arrays.asList(msgsAt.keys()));
                propertyKeys.addAll(Arrays.asList(msgsAt.value()));
            }
            if (propertyKeys.remove("")) {
                ignoreImplicit = false;
            }
            if (!ignoreImplicit) {
                this.addMsgKey(getterMethodElement, incorporatingTypeElement, prefix, propertyName, skipDuplicates);
            }
            this.addMsgKeys(getterMethodElement, incorporatingTypeElement, prefix, propertyName, propertyKeys, skipDuplicates);
        }
    }

    private void processFields(String prefix, TypeElement typeElement, boolean skipEnumConstants) {
        for (VariableElement fieldElement : LangModelUtils.getDeclaredFields(typeElement)) {
            List<Messages> fieldMsgsAt;
            if (skipEnumConstants && fieldElement.getKind() == ElementKind.ENUM_CONSTANT || (fieldMsgsAt = LangModelUtils.findMetaAnnotations(fieldElement, Messages.class)).isEmpty()) continue;
            LinkedHashSet<String> localParts = new LinkedHashSet<String>();
            String propertyName = fieldElement.getSimpleName().toString();
            for (Messages msgsAt : fieldMsgsAt) {
                if (!msgsAt.prefix().equals("__SOURCE_TYPE__")) {
                    String msg = "Prefix only allowed on type level.";
                    msg = String.format(msg, new Object[0]);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, fieldElement);
                }
                localParts.addAll(Arrays.asList(msgsAt.keys()));
                localParts.addAll(Arrays.asList(msgsAt.value()));
            }
            if (localParts.isEmpty()) {
                this.addMsgKey(fieldElement, typeElement, prefix, propertyName);
                continue;
            }
            this.addMsgKeys(fieldElement, typeElement, prefix, propertyName, localParts);
        }
    }

    private void processMethods(String prefix, TypeElement typeElement) {
        for (ExecutableElement methodElement : LangModelUtils.getDeclaredMethods(typeElement)) {
            List<Messages> methodMsgsAt;
            if (this.skipAsMethod.contains(methodElement) || (methodMsgsAt = LangModelUtils.findMetaAnnotations(methodElement, Messages.class)).isEmpty()) continue;
            LinkedHashSet<String> localParts = new LinkedHashSet<String>();
            for (Messages msgsAt : methodMsgsAt) {
                String msg;
                if (!msgsAt.prefix().equals("__SOURCE_TYPE__")) {
                    msg = "Prefix only allowed on type level.";
                    msg = String.format(msg, new Object[0]);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, methodElement);
                }
                localParts.addAll(Arrays.asList(msgsAt.keys()));
                localParts.addAll(Arrays.asList(msgsAt.value()));
                if (!localParts.isEmpty() && !localParts.remove("")) continue;
                msg = "Default message key not supported for methods.";
                msg = String.format(msg, new Object[0]);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, methodElement);
            }
            this.addMsgKeys(methodElement, typeElement, prefix, localParts);
        }
    }

    protected boolean updateMessageKeyIndex() {
        MessageKeyIndex index;
        this.messageKeysInProject = null;
        this.cleanBuild = false;
        String indexFilePath = MessageKeyIndex.getPreferredFilePath((String)this.projectConf.getModuleName());
        try {
            FileObject indexFile = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", indexFilePath);
            try (InputStream in = indexFile.openInputStream();){
                index = MessageKeyIndex.readFrom((InputStream)in);
            }
            this.cleanBuild = index.getSize() == 0;
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            index = new MessageKeyIndex();
            this.cleanBuild = true;
        }
        catch (AbstractPersistableData.PersistableDataException | IOException | RuntimeException ex) {
            if (ex.getMessage() != null && ex.getMessage().contains("does not exist")) {
                index = new MessageKeyIndex();
                this.cleanBuild = true;
            }
            String msg = "Failed to open message key index '%s'.";
            msg = String.format(msg, indexFilePath);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            LOG.log(Level.SEVERE, msg, ex);
            return false;
        }
        index.setModuleName(this.projectConf.getModuleName());
        index.setTargetLocales(this.projectConf.getTargetLocales());
        index.setBundleMappings(this.projectConf.getBundleMappings());
        index.setImportedModules(new ArrayList(this.projectConf.getImports()));
        index.setMessageFormat(this.projectConf.getMessageFormat());
        HashSet keysWithDefaultMessages = new HashSet();
        if (this.projectConf.getBundleDir() != null && this.messageBundleManager == null) {
            this.messageBundleManager = this.projectConf.createDefaultMessageBundleManager();
            for (BundleFile bundleFile : this.messageBundleManager.getBundleFiles(Locale.ROOT)) {
                keysWithDefaultMessages.addAll(bundleFile.getKeys());
            }
        }
        for (TypeElement type : this.messageKeysPerType.keySet()) {
            HashSet<MessageKeyWithSourceLocation> keys = new HashSet<MessageKeyWithSourceLocation>();
            Set pmks = this.messageKeysPerType.get((Object)type);
            for (ProcessedMessageKey pmk : pmks) {
                MessageKeyWithSourceLocation keyWithLocation;
                String code = pmk.getCode();
                String sourceType = type.getQualifiedName().toString();
                boolean defaultMessageAvailable = keysWithDefaultMessages.contains(code);
                if (pmk.getSourceElement() instanceof TypeElement) {
                    keyWithLocation = new MessageKeyWithSourceLocation(code, pmk.getArgTypes(), pmk.getArgNames(), sourceType, pmk.getLocalPart(), ElementType.TYPE, "", defaultMessageAvailable);
                } else if (pmk.getSourceElement() instanceof VariableElement) {
                    keyWithLocation = new MessageKeyWithSourceLocation(code, pmk.getArgTypes(), pmk.getArgNames(), sourceType, pmk.getLocalPart(), ElementType.FIELD, pmk.getSourceElement().getSimpleName().toString(), defaultMessageAvailable);
                } else {
                    if (!(pmk.getSourceElement() instanceof ExecutableElement)) continue;
                    keyWithLocation = new MessageKeyWithSourceLocation(code, pmk.getArgTypes(), pmk.getArgNames(), sourceType, pmk.getLocalPart(), ElementType.METHOD, pmk.getSourceElement().getSimpleName().toString(), defaultMessageAvailable);
                }
                keys.add(keyWithLocation);
            }
            index.updateWith(type.getQualifiedName().toString(), keys);
        }
        try {
            FileObject indexFile = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", indexFilePath, new Element[0]);
            index.writeTo(indexFile.openOutputStream());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Message key index of module '%s' updated.", this.projectConf.getModuleName()));
        }
        catch (AbstractPersistableData.PersistableDataException | IOException | RuntimeException ex) {
            String msg = "Failed to write message key index '%s'.";
            msg = String.format(msg, indexFilePath);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            LOG.log(Level.SEVERE, msg, ex);
        }
        this.messageKeysInProject = index;
        return this.messageKeysInProject != null;
    }

    protected void processBundleFiles() {
        if (this.projectConf.getMissingMessagePolicy() == MissingMessagePolicy.NONE && this.projectConf.getMessageArgPolicy() == MessageArgPolicy.NONE && this.projectConf.getUndeclaredKeyPolicy() == UndeclaredKeyPolicy.NONE && this.projectConf.getBundleMismatchPolicy() == BundleMismatchPolicy.NONE) {
            return;
        }
        if (this.messageFormatSupport == null) {
            this.messageFormatSupport = MessageFormatSupport.getSupport((ProjectConf)this.projectConf);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Using '%s' message formatter to validate message arguments.", this.projectConf.getMessageFormat()));
        }
        this.loadImportedModules();
        try {
            this.projectConf.resolveBundleMappings(moduleName -> (MessageModule)this.importedMessageKeysPerModule.get(moduleName));
        }
        catch (ProjectConfException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
            return;
        }
        if (this.messageKeysInProject == null) {
            return;
        }
        long messageBundleProcessingStart = System.currentTimeMillis();
        if (this.messageBundleManager == null) {
            this.messageBundleManager = this.projectConf.createDefaultMessageBundleManager();
        }
        if (this.cleanBuild) {
            this.checkUndeclaredKeys();
            this.checkBundleMismatches();
        }
        this.checkMessages();
        try {
            this.messageBundleManager.save(true);
        }
        catch (BundleException ex) {
            String msg = "Failed to save all message bundle files of module '%s'.";
            msg = String.format(msg, this.projectConf.getModuleName());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            LOG.log(Level.SEVERE, msg, ex);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Processing message bundle files of module '%s' took %sms.", this.projectConf.getModuleName(), System.currentTimeMillis() - messageBundleProcessingStart));
    }

    private void loadImportedModules() {
        ArrayDeque importedModulesToLoad = new ArrayDeque(this.projectConf.getImports());
        HashSet<String> loadedModules = new HashSet<String>();
        while (!importedModulesToLoad.isEmpty()) {
            String msg;
            String moduleName = (String)importedModulesToLoad.pop();
            if (!loadedModules.add(moduleName)) continue;
            String keysFilePath = MessageKeyIndex.getPreferredFilePath((String)moduleName);
            try {
                MessageKeyIndex importedKeysIndex;
                InputStreamSupplier importedKeysFile = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_PATH, "", keysFilePath)::openInputStream;
                try (InputStream in = importedKeysFile.openInputStream();){
                    importedKeysIndex = MessageKeyIndex.readFrom((InputStream)in);
                }
                importedKeysIndex.getImportedModules().stream().forEach(importedModulesToLoad::push);
                this.importedMessageKeysPerModule.put(moduleName, importedKeysIndex);
                if (this.messageFormatSupport.supportsFormat(importedKeysIndex.getMessageFormat())) continue;
                String msg2 = "Message format '%s' used by imported message keys '%s' [%s] not supported by message format '%s'.";
                msg2 = String.format(msg2, importedKeysIndex.getMessageFormat(), moduleName, keysFilePath, this.projectConf.getMessageFormat());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg2);
            }
            catch (FileNotFoundException | NoSuchFileException ex) {
                msg = "Imported message keys '%s' [%s] not found.";
                msg = String.format(msg, moduleName, keysFilePath);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                LOG.log(Level.SEVERE, msg, ex);
                this.messageKeysIncomplete = true;
                this.importsLoaded = false;
            }
            catch (AbstractPersistableData.PersistableDataException | IOException | RuntimeException ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("does not exist")) {
                    msg = "Imported message keys '%s' [%s] not found.";
                    msg = String.format(msg, moduleName, keysFilePath);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                    LOG.log(Level.SEVERE, msg, ex);
                } else {
                    msg = "Failed to import message keys '%s' [%s].";
                    msg = String.format(msg, moduleName, keysFilePath);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                    LOG.log(Level.SEVERE, msg, ex);
                }
                this.messageKeysIncomplete = true;
                this.importsLoaded = false;
            }
        }
    }

    private boolean checkUnmappedKeys() {
        if (this.projectConf.getBundleDir() == null) {
            return true;
        }
        AtomicBoolean containsUnmapped = new AtomicBoolean(false);
        this.messageKeysInProject.getKeys().forEach(key -> {
            if (!this.projectConf.toTargetBundleName(key.getCode(), true).isPresent()) {
                containsUnmapped.set(true);
                String msg = "No message bundle mapping found for declared message key '%s'.";
                msg = String.format(msg, key.getCode());
                TypeElement sourceTypeElement = this.processingEnv.getElementUtils().getTypeElement(key.getSourceType());
                Element errorLocationElement = null;
                if (sourceTypeElement != null) {
                    switch (key.getSourceElementType()) {
                        case FIELD: {
                            errorLocationElement = LangModelUtils.getDeclaredFields(sourceTypeElement).stream().filter(ve -> ve.getSimpleName().toString().equals(key.getSourceElementName())).findFirst().orElse(null);
                            break;
                        }
                        case METHOD: {
                            errorLocationElement = LangModelUtils.getDeclaredMethods(sourceTypeElement).stream().filter(ee -> ee.getSimpleName().toString().equals(key.getSourceElementName())).findFirst().orElse(null);
                            break;
                        }
                        default: {
                            errorLocationElement = sourceTypeElement;
                        }
                    }
                }
                if (errorLocationElement == null) {
                    errorLocationElement = sourceTypeElement;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, errorLocationElement);
            }
        });
        return !containsUnmapped.get();
    }

    private void checkUndeclaredKeys() {
        if (this.messageKeysIncomplete || this.projectConf.getUndeclaredKeyPolicy() == UndeclaredKeyPolicy.NONE) {
            return;
        }
        Set declaredKeys = this.messageKeysInProject.getKeys().map(MessageKeyWithSourceLocation::getCode).collect(Collectors.toSet());
        for (String moduleName : this.listImportedModules()) {
            MessageKeyIndex messageKeyIndex = this.importedMessageKeysPerModule.get(moduleName);
            messageKeyIndex.getKeys().map(MessageKeyWithSourceLocation::getCode).forEach(declaredKeys::add);
        }
        for (BundleFile bundleFile : this.messageBundleManager.getBundleFiles()) {
            Set keys = bundleFile.getKeys();
            for (String key : keys) {
                if (!declaredKeys.contains(key)) {
                    String msg;
                    if (bundleFile.isMessageEmpty(key)) {
                        bundleFile.removeMessage(key);
                        continue;
                    }
                    if (this.projectConf.getUndeclaredKeyPolicy() == UndeclaredKeyPolicy.ADD_COMMENT_AND_WARN) {
                        bundleFile.setComment(key, this.projectConf.getUndeclaredKeyComment());
                    }
                    if (this.projectConf.getUndeclaredKeyPolicy() == UndeclaredKeyPolicy.ADD_COMMENT_AND_WARN || this.projectConf.getUndeclaredKeyPolicy() == UndeclaredKeyPolicy.WARN || this.projectConf.getUndeclaredKeyPolicy() == UndeclaredKeyPolicy.FAIL) {
                        msg = "Undeclared message key '%s' in message bundle file '%s'.";
                        msg = String.format(msg, key, bundleFile.getDisplayPath());
                        Diagnostic.Kind kind = this.projectConf.getUndeclaredKeyPolicy() == UndeclaredKeyPolicy.FAIL ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                        this.processingEnv.getMessager().printMessage(kind, msg);
                    }
                    if (this.projectConf.getUndeclaredKeyPolicy() != UndeclaredKeyPolicy.REMOVE) continue;
                    bundleFile.removeMessage(key);
                    msg = "Undeclared message key '%s' in message bundle file '%s' will be removed.";
                    msg = String.format(msg, key, bundleFile.getDisplayPath());
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
                    continue;
                }
                if (this.projectConf.getUndeclaredKeyPolicy() != UndeclaredKeyPolicy.ADD_COMMENT_AND_WARN || !this.projectConf.getUndeclaredKeyComment().equals(bundleFile.getComment(key))) continue;
                bundleFile.setComment(key, null);
            }
        }
    }

    private void checkBundleMismatches() {
        if (this.projectConf.getBundleMismatchPolicy() == BundleMismatchPolicy.NONE) {
            return;
        }
        for (BundleFile bundleFile : this.messageBundleManager.getBundleFiles()) {
            for (String key : bundleFile.getKeys()) {
                String expectedBundleName;
                if (!this.processedMessageKeys.containsKey(key) || (expectedBundleName = (String)this.projectConf.toTargetBundleName(key).orElse(null)) == null) continue;
                BundleFile expectedBundleFile = this.messageBundleManager.getBundleFile(expectedBundleName, bundleFile.getLocale(), true);
                if (bundleFile.getBundleName().equals(expectedBundleName)) continue;
                if (this.projectConf.getBundleMismatchPolicy() == BundleMismatchPolicy.MOVE) {
                    String message = bundleFile.getMessage(key);
                    String comment = bundleFile.getComment(key);
                    if (expectedBundleFile.hasMessageKey(key)) {
                        String msg;
                        String messageInTarget = expectedBundleFile.getMessage(key);
                        if (StringUtils.isEmpty((CharSequence)messageInTarget)) {
                            msg = "Message key '%s' does not match bundle file '%s'. Moving to '%s'.";
                            msg = String.format(msg, key, bundleFile.getDisplayPath(), expectedBundleFile.getDisplayPath());
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
                            bundleFile.removeMessage(key);
                            expectedBundleFile.setMessage(key, message);
                            expectedBundleFile.setComment(key, comment);
                            continue;
                        }
                        if (StringUtils.isEmpty((CharSequence)message)) {
                            msg = "Message key '%s' does not match bundle file '%s'. Message is empty, so just removing.";
                            msg = String.format(msg, key, bundleFile.getDisplayPath());
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
                            bundleFile.removeMessage(key);
                            continue;
                        }
                        if (message.equals(messageInTarget)) {
                            msg = "Message key '%s' does not match bundle file '%s'. Message in '%s' is already the same, so just removing.";
                            msg = String.format(msg, key, bundleFile.getDisplayPath(), expectedBundleFile.getDisplayPath());
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
                            bundleFile.removeMessage(key);
                            continue;
                        }
                        msg = "Message key '%s' does not match bundle file '%s'. However, the message key already exists in '%s' with a different message. You need to manually reconcile this.";
                        msg = String.format(msg, key, bundleFile.getDisplayPath(), expectedBundleFile.getDisplayPath());
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
                        continue;
                    }
                    String msg = "Message key '%s' does not match bundle file '%s'. Moving to '%s'.";
                    msg = String.format(msg, key, bundleFile.getDisplayPath(), expectedBundleFile.getDisplayPath());
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
                    bundleFile.removeMessage(key);
                    expectedBundleFile.setMessage(key, message);
                    expectedBundleFile.setComment(key, comment);
                    continue;
                }
                if (this.projectConf.getBundleMismatchPolicy() != BundleMismatchPolicy.WARN) continue;
                String msg = "Message key '%s' does not match bundle file '%s'.";
                msg = String.format(msg, key, bundleFile.getDisplayPath());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
            }
        }
    }

    private void checkMessages() {
        if (this.cleanBuild) {
            this.messagesInProject = HashMultimap.create();
        }
        ArrayListMultimap missingKeys = ArrayListMultimap.create();
        ArrayListMultimap missingMessages = ArrayListMultimap.create();
        for (ProcessedMessageKey pmk : this.processedMessageKeys.values()) {
            Set<Locale> requiredLocales = this.getRequiredLocale(pmk.getCode());
            Pair<Boolean, Boolean> resultForRoot = this.checkMessageForLocale(pmk, Locale.ROOT, pmk.getSourceElement());
            boolean keyFoundForRoot = (Boolean)resultForRoot.getLeft();
            boolean messageFoundForRoot = (Boolean)resultForRoot.getRight();
            if (keyFoundForRoot && this.messagesInProject != null) {
                this.messagesInProject.put((Object)Locale.ROOT, (Object)pmk);
            }
            if (keyFoundForRoot && !messageFoundForRoot) {
                missingMessages.put((Object)Locale.ROOT, (Object)Pair.of((Object)pmk, (Object)pmk.getSourceElement()));
            }
            for (Locale locale2 : this.projectConf.getTargetLocales()) {
                boolean requiredForLocale = requiredLocales.contains(locale2);
                Pair<Boolean, Boolean> resultForLocale = this.checkMessageForLocale(pmk, locale2, pmk.getSourceElement());
                boolean keyFoundForLocale = (Boolean)resultForLocale.getLeft();
                boolean messageFoundForLocale = (Boolean)resultForLocale.getRight();
                if (keyFoundForLocale && this.messagesInProject != null) {
                    this.messagesInProject.put((Object)locale2, (Object)pmk);
                }
                if (keyFoundForLocale && !messageFoundForLocale) {
                    missingMessages.put((Object)locale2, (Object)Pair.of((Object)pmk, (Object)pmk.getSourceElement()));
                }
                if (keyFoundForRoot || keyFoundForLocale || !requiredForLocale) continue;
                missingKeys.put((Object)locale2, (Object)Pair.of((Object)pmk, (Object)pmk.getSourceElement()));
                missingMessages.put((Object)locale2, (Object)Pair.of((Object)pmk, (Object)pmk.getSourceElement()));
            }
        }
        if (this.cleanBuild && this.importsLoaded) {
            for (String moduleName : this.listImportedModules()) {
                MessageKeyIndex importedKeys = this.importedMessageKeysPerModule.get(moduleName);
                ArrayList missingLocales = new ArrayList(this.projectConf.getTargetLocales());
                missingLocales.removeAll(importedKeys.getTargetLocales());
                if (missingLocales.isEmpty()) continue;
                importedKeys.getKeys().forEach(arg_0 -> this.lambda$checkMessages$11((ListMultimap)missingMessages, missingLocales, (ListMultimap)missingKeys, arg_0));
            }
        }
        if (!(missingKeys.isEmpty() || this.projectConf.getMissingMessagePolicy() != MissingMessagePolicy.ADD_AND_WARN && this.projectConf.getMissingMessagePolicy() != MissingMessagePolicy.ADD)) {
            missingKeys.forEach((locale, pair) -> {
                MessageKeyWithArgs messageKey = (MessageKeyWithArgs)pair.getLeft();
                Element sourceElement = (Element)pair.getRight();
                String targetBundleName = this.projectConf.toTargetBundleName(messageKey.getCode()).orElse(null);
                if (targetBundleName == null) {
                    return;
                }
                BundleFile bundleFile = this.messageBundleManager.getBundleFile(targetBundleName, locale, true);
                bundleFile.setMessage(messageKey.getCode(), "");
                this.updateMessageArgDocComment(messageKey, (BundleFile<Path>)bundleFile);
                String msg = "%s:%s [%s] Empty message stub created.";
                msg = String.format(msg, messageKey.getCode(), locale, bundleFile.getDisplayPath());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg, sourceElement);
            });
        }
        if (this.cleanBuild) {
            Diagnostic.Kind messageKind;
            switch (this.projectConf.getMissingMessagePolicy()) {
                case FAIL: {
                    messageKind = Diagnostic.Kind.ERROR;
                    break;
                }
                case ADD_AND_WARN: 
                case WARN: {
                    messageKind = Diagnostic.Kind.WARNING;
                    break;
                }
                default: {
                    messageKind = null;
                }
            }
            if (!missingMessages.isEmpty() && messageKind != null) {
                missingMessages.forEach((locale, pair) -> {
                    MessageKeyWithArgs messageKey = (MessageKeyWithArgs)pair.getLeft();
                    Element sourceElement = (Element)pair.getRight();
                    String targetBundleName = this.projectConf.toTargetBundleName(messageKey.getCode()).orElse(null);
                    if (targetBundleName == null) {
                        return;
                    }
                    BundleFile bundleFile = this.messageBundleManager.getBundleFile(targetBundleName, locale, true);
                    String msg = "%s:%s [%s] Message is missing.";
                    msg = String.format(msg, messageKey.getCode(), locale, bundleFile.getDisplayPath());
                    this.processingEnv.getMessager().printMessage(messageKind, msg, sourceElement);
                });
            }
        }
    }

    private Set<Locale> getRequiredLocale(String messageKeyCode) {
        HashMap<String, MessageKeyIndex> importedIndexes = new HashMap<String, MessageKeyIndex>();
        for (String importedModule : this.messageKeysInProject.getImportedModules()) {
            MessageKeyIndex importedIndex = this.importedMessageKeysPerModule.get(importedModule);
            if (importedIndex == null) {
                throw new RuntimeException("Imported module not found: " + importedModule);
            }
            importedIndexes.put(importedModule, importedIndex);
        }
        return MessageValidationUtils.getRequiredLocales((String)messageKeyCode, (MessageModule)this.messageKeysInProject, importedIndexes, (module, code) -> ((MessageKeyIndex)module).getKey(code) != null);
    }

    private Pair<Boolean, Boolean> checkMessageForLocale(MessageKeyWithArgs messageKey, Locale locale, Element sourceElement) {
        String targetBundleName = this.projectConf.toTargetBundleName(messageKey.getCode()).orElse(null);
        if (targetBundleName == null) {
            return Pair.of((Object)false, (Object)false);
        }
        boolean checkNonTargetBundles = this.projectConf.getBundleMismatchPolicy() != BundleMismatchPolicy.MOVE;
        boolean keyFound = false;
        boolean messageFound = false;
        BundleFile targetBundleFile = this.messageBundleManager.getBundleFile(targetBundleName, locale);
        if (targetBundleFile != null && targetBundleFile.hasMessageKey(messageKey.getCode())) {
            keyFound = true;
            if (!targetBundleFile.isMessageEmpty(messageKey.getCode())) {
                messageFound = true;
                this.checkMessageArgs(messageKey, locale, (BundleFile<Path>)targetBundleFile, sourceElement);
            }
            this.updateMessageArgDocComment(messageKey, (BundleFile<Path>)targetBundleFile);
        } else if (checkNonTargetBundles) {
            for (BundleFile bundleFile : this.messageBundleManager.getBundleFiles(locale)) {
                if (bundleFile.getBundleName().equals(targetBundleName) || !bundleFile.hasMessageKey(messageKey.getCode())) continue;
                keyFound = true;
                if (!bundleFile.isMessageEmpty(messageKey.getCode())) {
                    messageFound = true;
                    this.checkMessageArgs(messageKey, locale, (BundleFile<Path>)bundleFile, sourceElement);
                }
                this.updateMessageArgDocComment(messageKey, (BundleFile<Path>)bundleFile);
                break;
            }
        }
        return Pair.of((Object)keyFound, (Object)messageFound);
    }

    private void checkMessageArgs(MessageKeyWithArgs messageKey, Locale locale, BundleFile<Path> bundleFile, Element sourceElement) {
        Diagnostic.Kind severity;
        switch (this.projectConf.getMessageArgPolicy()) {
            case FAIL: {
                severity = Diagnostic.Kind.ERROR;
                break;
            }
            case WARN: {
                severity = Diagnostic.Kind.WARNING;
                break;
            }
            default: {
                severity = null;
            }
        }
        if (severity == null) {
            return;
        }
        String message = bundleFile.getMessage(messageKey.getCode());
        List errors = this.messageFormatSupport.checkMessage(message, messageKey.getArgTypes(), messageKey.getArgNames(), (typeName, allowedTypeNames) -> {
            if (PRIMITIVE_TYPES.isEmpty()) {
                for (TypeKind typeKind : TypeKind.values()) {
                    if (!typeKind.isPrimitive()) continue;
                    PRIMITIVE_TYPES.put(typeKind.name().toLowerCase(Locale.ENGLISH), this.processingEnv.getTypeUtils().getPrimitiveType(typeKind));
                }
            }
            if (allowedTypeNames.contains(typeName)) {
                return true;
            }
            TypeElement argTypeElement = this.processingEnv.getElementUtils().getTypeElement(typeName);
            TypeMirror argTypeMirror = argTypeElement == null ? (TypeMirror)PRIMITIVE_TYPES.get(typeName) : argTypeElement.asType();
            if (argTypeMirror == null) {
                return false;
            }
            for (String expectedArgType : allowedTypeNames) {
                TypeElement expectedArgTypeElement = this.processingEnv.getElementUtils().getTypeElement(expectedArgType);
                if (expectedArgTypeElement == null || !this.processingEnv.getTypeUtils().isAssignable(argTypeMirror, expectedArgTypeElement.asType())) continue;
                return true;
            }
            return false;
        });
        for (String error : errors) {
            String msg = "%s:%s [%s] %s";
            msg = String.format(msg, messageKey, locale, bundleFile.getDisplayPath(), error);
            this.processingEnv.getMessager().printMessage(severity, msg, sourceElement);
        }
    }

    private void updateMessageArgDocComment(MessageKeyWithArgs messageKey, BundleFile<Path> bundleFile) {
        if (this.projectConf.getMissingMessagePolicy() == MissingMessagePolicy.ADD_AND_WARN || this.projectConf.getMissingMessagePolicy() == MissingMessagePolicy.ADD) {
            String comment = this.messageFormatSupport.createMessageBundleComment(messageKey);
            bundleFile.setComment(messageKey.getCode(), comment);
        }
    }

    private void addMsgKey(Element sourceElement, TypeElement owningTypeElement, String prefix, String localPart) {
        this.addMsgKey(sourceElement, owningTypeElement, prefix, null, localPart, false);
    }

    private void addMsgKey(Element sourceElement, TypeElement owningTypeElement, String prefix, String localPart, boolean skipDuplicate) {
        this.addMsgKey(sourceElement, owningTypeElement, prefix, null, localPart, skipDuplicate);
    }

    private void addMsgKey(Element sourceElement, TypeElement owningTypeElement, String prefix, String localPartPrefix, String localPart, boolean skipDuplicate) {
        String msg;
        String[] argTypes = null;
        String[] argNames = null;
        if (localPart != null && (localPart.contains("->") || localPart.contains(","))) {
            List<String> argsList;
            if (localPart.contains("->")) {
                argsList = Arrays.asList(StringUtils.splitPreserveAllTokens((String)StringUtils.substringAfter((String)localPart, (String)"->"), (String)","));
                localPart = StringUtils.trim((String)StringUtils.substringBefore((String)localPart, (String)"->"));
            } else {
                String[] tokens = StringUtils.splitPreserveAllTokens((String)localPart, (String)",");
                localPart = tokens[0].trim();
                argsList = Arrays.asList(tokens).subList(1, tokens.length);
            }
            ArrayList<String> argTypesList = new ArrayList<String>();
            ArrayList<String> argNamesList = new ArrayList<String>();
            for (String arg : argsList) {
                String msg2;
                arg = arg.trim();
                String argName = null;
                String argTypeString = null;
                if (arg.contains(":")) {
                    String[] argTokens = StringUtils.splitPreserveAllTokens((String)arg, (String)":", (int)2);
                    argName = argTokens[0].trim();
                    argTypeString = argTokens[1].trim();
                }
                if (argName == null || argTypeString == null) {
                    msg2 = "Illegal format for message arguments.";
                    msg2 = String.format(msg2, new Object[0]);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg2, sourceElement);
                    continue;
                }
                if (argName.isEmpty()) {
                    msg2 = "Message argument name must not be empty.";
                    msg2 = String.format(msg2, new Object[0]);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg2, sourceElement);
                    continue;
                }
                if (!argTypeString.contains(".")) {
                    String argType = (String)this.projectConf.getTypeAbbreviations().get(argTypeString);
                    if (argType == null) {
                        argType = DEFAULT_TYPE_ABBREVIATIONS.get(argTypeString);
                    }
                    if (argType != null) {
                        argTypeString = argType;
                    }
                }
                argNamesList.add(argName);
                argTypesList.add(argTypeString);
            }
            argNames = argNamesList.toArray(new String[argNamesList.size()]);
            argTypes = argTypesList.toArray(new String[argTypesList.size()]);
        }
        String fullLocalPart = StringUtils.isNotEmpty((CharSequence)localPartPrefix) ? (StringUtils.isNotEmpty((CharSequence)localPart) ? localPartPrefix + "_" + localPart : localPartPrefix) : (StringUtils.isNotEmpty((CharSequence)localPart) ? localPart : null);
        if (fullLocalPart == null) {
            msg = "Local part of message key must not be empty.";
            msg = String.format(msg, fullLocalPart);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, sourceElement);
            return;
        }
        if (!SourceVersion.isIdentifier(fullLocalPart)) {
            msg = "Local part '%s' of message key is not a valid Java identifier.";
            msg = String.format(msg, fullLocalPart);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, sourceElement);
            return;
        }
        ProcessedMessageKey key = new ProcessedMessageKey(sourceElement, owningTypeElement, prefix, fullLocalPart, argTypes, argNames);
        if (this.processedMessageKeys.containsKey(key.getCode())) {
            if (!skipDuplicate) {
                String msg3 = "Message key '%s' already declared.";
                msg3 = String.format(msg3, key.getCode());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg3, sourceElement);
            }
        } else {
            this.messageKeysPerType.put((Object)owningTypeElement, (Object)key);
            this.processedMessageKeys.put(key.getCode(), key);
        }
    }

    private void addMsgKeys(Element sourceElement, TypeElement owningTypeElement, String prefix, Collection<String> localParts) {
        for (String localPart : localParts) {
            this.addMsgKey(sourceElement, owningTypeElement, prefix, localPart);
        }
    }

    private void addMsgKeys(Element sourceElement, TypeElement owningTypeElement, String prefix, String localPartPrefix, Collection<String> localParts) {
        this.addMsgKeys(sourceElement, owningTypeElement, prefix, localPartPrefix, localParts, false);
    }

    private void addMsgKeys(Element sourceElement, TypeElement owningTypeElement, String prefix, String localPartPrefix, Collection<String> localParts, boolean skipDuplicates) {
        for (String localPart : localParts) {
            this.addMsgKey(sourceElement, owningTypeElement, prefix, localPartPrefix, localPart, skipDuplicates);
        }
    }

    private Set<ProcessedMessageKey> getMsgKeys(TypeElement owningTypeElement) {
        return this.messageKeysPerType.get((Object)owningTypeElement);
    }

    private static ClassName getMessageConstantsClassName(TypeElement owningTypeElement) {
        String simpleClassName = MessageCodegenUtils.getMessageConstantsSimpleTypeNameFor((String)MessageKeyProcessor.getMessageOwnerSimpleClassName(owningTypeElement));
        return ClassName.get((String)LangModelUtils.getPackage(owningTypeElement).getQualifiedName().toString(), (String)simpleClassName, (String[])new String[0]);
    }

    private static String getMessageConstantsClassNameString(TypeElement owningTypeElement) {
        String simpleClassName = MessageCodegenUtils.getMessageConstantsSimpleTypeNameFor((String)MessageKeyProcessor.getMessageOwnerSimpleClassName(owningTypeElement));
        return LangModelUtils.getPackage(owningTypeElement).getQualifiedName().toString() + "." + simpleClassName;
    }

    private static ClassName getMessageProxiesClassName(TypeElement owningTypeElement) {
        String simpleClassName = MessageCodegenUtils.getMessageProxiesSimpleTypeNameFor((String)MessageKeyProcessor.getMessageOwnerSimpleClassName(owningTypeElement));
        return ClassName.get((String)LangModelUtils.getPackage(owningTypeElement).getQualifiedName().toString(), (String)simpleClassName, (String[])new String[0]);
    }

    private static String getMessageProxiesClassNameString(TypeElement owningTypeElement) {
        String simpleClassName = MessageCodegenUtils.getMessageProxiesSimpleTypeNameFor((String)MessageKeyProcessor.getMessageOwnerSimpleClassName(owningTypeElement));
        return LangModelUtils.getPackage(owningTypeElement).getQualifiedName().toString() + "." + simpleClassName;
    }

    static String getMessageOwnerSimpleClassName(TypeElement owningTypeElement) {
        return LangModelUtils.getTypeNesting(owningTypeElement).stream().map(te -> te.getSimpleName().toString()).collect(Collectors.joining("."));
    }

    private boolean hasMessageConstants(TypeElement owningTypeElement) {
        String owningClassName = owningTypeElement.getQualifiedName().toString();
        if (this.withMessageConstants.contains(owningClassName)) {
            return true;
        }
        if (this.processingEnv.getElementUtils().getTypeElement(MessageKeyProcessor.getMessageConstantsClassNameString(owningTypeElement)) != null) {
            this.withMessageConstants.add(owningClassName);
            return true;
        }
        return false;
    }

    private boolean hasMessageProxies(TypeElement owningTypeElement) {
        String owningClassName = owningTypeElement.getQualifiedName().toString();
        if (this.withMessageProxies.contains(owningClassName)) {
            return true;
        }
        if (this.processingEnv.getElementUtils().getTypeElement(MessageKeyProcessor.getMessageProxiesClassNameString(owningTypeElement)) != null) {
            this.withMessageProxies.add(owningClassName);
            return true;
        }
        return false;
    }

    private List<String> listImportedModules() {
        HashSet<String> foundModules = new HashSet<String>();
        ArrayList<String> importedModules = new ArrayList<String>();
        ArrayDeque stack = new ArrayDeque(this.projectConf.getImports());
        while (!stack.isEmpty()) {
            String moduleName = (String)stack.pop();
            if (!foundModules.add(moduleName)) continue;
            importedModules.add(moduleName);
            MessageKeyIndex messageKeyIndex = this.importedMessageKeysPerModule.get(moduleName);
            messageKeyIndex.getImportedModules().stream().forEach(stack::push);
        }
        return importedModules;
    }

    private /* synthetic */ void lambda$checkMessages$11(ListMultimap missingMessages, List missingLocales, ListMultimap missingKeys, MessageKeyWithSourceLocation key) {
        Pair<Boolean, Boolean> resultForRoot = this.checkMessageForLocale((MessageKeyWithArgs)key, Locale.ROOT, null);
        boolean keyFoundForRoot = (Boolean)resultForRoot.getLeft();
        boolean messageFoundForRoot = (Boolean)resultForRoot.getRight();
        if (keyFoundForRoot && !messageFoundForRoot) {
            missingMessages.put((Object)Locale.ROOT, (Object)Pair.of((Object)key, null));
        }
        Set<Locale> requiredLocales = this.getRequiredLocale(key.getCode());
        for (Locale locale : missingLocales) {
            boolean requiredForLocale = requiredLocales.contains(locale);
            Pair<Boolean, Boolean> resultForLocale = this.checkMessageForLocale((MessageKeyWithArgs)key, locale, null);
            boolean keyFoundForLocale = (Boolean)resultForLocale.getLeft();
            boolean messageFoundForLocale = (Boolean)resultForLocale.getRight();
            if (keyFoundForLocale && !messageFoundForLocale) {
                missingMessages.put((Object)locale, (Object)Pair.of((Object)key, null));
            }
            if (key.isDefaultMessageAvailable() || keyFoundForRoot || keyFoundForLocale || !requiredForLocale) continue;
            missingKeys.put((Object)locale, (Object)Pair.of((Object)key, null));
            missingMessages.put((Object)locale, (Object)Pair.of((Object)key, null));
        }
    }

    static {
        DEFAULT_TYPE_ABBREVIATIONS.put("*", Object.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("b", Boolean.TYPE.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("B", Boolean.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("i", Integer.TYPE.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("I", Integer.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("l", Long.TYPE.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("L", Long.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("f", Float.TYPE.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("F", Float.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("d", Double.TYPE.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("D", Double.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("BI", BigInteger.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("BigInteger", BigInteger.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("BD", BigDecimal.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("BigDecimal", BigDecimal.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("N", Number.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("Number", Number.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("s", String.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("S", String.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("string", String.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("String", String.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("Date", Date.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("LocalDate", LocalDate.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("LocalTime", LocalTime.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("LocalDateTime", LocalDateTime.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("Instant", Instant.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("ZonedDateTime", ZonedDateTime.class.getName());
        DEFAULT_TYPE_ABBREVIATIONS.put("money", "javax.money.MonetaryAmount");
        DEFAULT_TYPE_ABBREVIATIONS.put("Money", "javax.money.MonetaryAmount");
        DEFAULT_TYPE_ABBREVIATIONS.put("MonetaryAmount", "javax.money.MonetaryAmount");
        PRIMITIVE_TYPES = new HashMap<String, PrimitiveType>();
        LOG = Logger.getLogger(MessageKeyProcessor.class.getName());
    }

    @FunctionalInterface
    public static interface InputStreamSupplier {
        public InputStream openInputStream() throws IOException;
    }
}

