/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import de.codecamp.messages.codegen.MessageCodegenUtils;
import de.codecamp.messages.codegen.MessageProxyInterface;
import de.codecamp.messages.codegen.MessageProxyMethod;
import de.codecamp.messages.codegen.MessageProxyParam;
import de.codecamp.messages.processor.MessageKeyProcessor;
import de.codecamp.messages.proxy.MessageProxy;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class MessageProxyFileBuilder {
    private TypeElement owningTypeElement;
    private String packageName;
    private String constantsSimpleTypeName;
    private TypeSpec.Builder typeSpecBuilder;

    public MessageProxyFileBuilder(TypeElement owningTypeElement, ClassName generatedAnntation, String packageName) {
        this.owningTypeElement = owningTypeElement;
        this.packageName = packageName;
        this.constantsSimpleTypeName = MessageCodegenUtils.getMessageProxiesSimpleTypeNameFor((String)MessageKeyProcessor.getMessageOwnerSimpleClassName(owningTypeElement));
        this.initBuilder(generatedAnntation);
    }

    private void initBuilder(ClassName generatedAnntation) {
        this.typeSpecBuilder = TypeSpec.interfaceBuilder((String)this.constantsSimpleTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.typeSpecBuilder.addSuperinterface((TypeName)ClassName.get(MessageProxy.class));
        if (generatedAnntation != null) {
            AnnotationSpec generatedAtSpec = AnnotationSpec.builder((ClassName)generatedAnntation).addMember("value", "$S", new Object[]{MessageKeyProcessor.class.getName()}).build();
            this.typeSpecBuilder.addAnnotation(generatedAtSpec);
        }
        AnnotationSpec messageProxyAtSpec = AnnotationSpec.builder(MessageProxyInterface.class).addMember("sourceType", "$T.class", new Object[]{ClassName.get((TypeElement)this.owningTypeElement)}).build();
        this.typeSpecBuilder.addAnnotation(messageProxyAtSpec);
    }

    public TypeSpec.Builder getTypeSpecBuilder() {
        return this.typeSpecBuilder;
    }

    public String getConstantsSimpleTypeName() {
        return this.constantsSimpleTypeName;
    }

    public void addMessageMethod(String constantName, String messageKey, String[] argTypes, String[] argNames) {
        AnnotationSpec messageProxyMethodAtSpec = AnnotationSpec.builder(MessageProxyMethod.class).addMember("code", "$S", new Object[]{messageKey}).build();
        if (SourceVersion.isKeyword(constantName)) {
            constantName = constantName + "_";
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)constantName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(messageProxyMethodAtSpec).returns(String.class);
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                String argType = argTypes[i];
                String argName = argNames[i];
                ClassName argTypeName = argType.contains(".") ? ClassName.bestGuess((String)argType) : ClassName.get((String)"", (String)argType, (String[])new String[0]);
                String paramName = argName == null ? "arg" + i : argName;
                ParameterSpec.Builder builder = ParameterSpec.builder((TypeName)argTypeName, (String)paramName, (Modifier[])new Modifier[0]);
                if (argName != null) {
                    builder.addAnnotation(AnnotationSpec.builder(MessageProxyParam.class).addMember("name", "$S", new Object[]{argName}).build());
                }
                methodBuilder.addParameter(builder.build());
            }
        }
        this.typeSpecBuilder.addMethod(methodBuilder.build());
    }

    public void writeTo(Filer filer) throws IOException {
        TypeSpec typeSpec = this.typeSpecBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).build();
        javaFile.writeTo(filer);
    }
}

