/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import de.codecamp.messages.ResolvableMessage;
import de.codecamp.messages.codegen.DeclaredMessageKey;
import de.codecamp.messages.codegen.MessageCodegenUtils;
import de.codecamp.messages.codegen.MessageKeyConstants;
import de.codecamp.messages.processor.MessageKeyProcessor;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class MessageKeyConstantsFileBuilder {
    private TypeElement owningTypeElement;
    private String packageName;
    private String constantsSimpleTypeName;
    private TypeSpec.Builder typeSpecBuilder;

    public MessageKeyConstantsFileBuilder(TypeElement owningTypeElement, ClassName generatedAnnotation, String packageName) {
        this.owningTypeElement = owningTypeElement;
        this.packageName = packageName;
        this.constantsSimpleTypeName = MessageCodegenUtils.getMessageConstantsSimpleTypeNameFor((String)MessageKeyProcessor.getMessageOwnerSimpleClassName(owningTypeElement));
        this.initBuilder(generatedAnnotation);
    }

    private void initBuilder(ClassName generatedAnnotation) {
        this.typeSpecBuilder = TypeSpec.interfaceBuilder((String)this.constantsSimpleTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (generatedAnnotation != null) {
            AnnotationSpec generatedAtSpec = AnnotationSpec.builder((ClassName)generatedAnnotation).addMember("value", "$S", new Object[]{MessageKeyProcessor.class.getName()}).build();
            this.typeSpecBuilder.addAnnotation(generatedAtSpec);
        }
        AnnotationSpec messageKeyConstantsAtSpec = AnnotationSpec.builder(MessageKeyConstants.class).addMember("value", "$T.class", new Object[]{ClassName.get((TypeElement)this.owningTypeElement)}).build();
        this.typeSpecBuilder.addAnnotation(messageKeyConstantsAtSpec);
    }

    public TypeSpec.Builder getTypeSpecBuilder() {
        return this.typeSpecBuilder;
    }

    public String getConstantsSimpleTypeName() {
        return this.constantsSimpleTypeName;
    }

    public void addMessageKey(String constantName, String code, String[] argTypes, String[] argNames) {
        int i;
        String argNamesString;
        String argTypesString;
        if (argTypes == null || argTypes.length == 0) {
            argTypesString = "null";
            argNamesString = "null";
        } else {
            argTypesString = Stream.of(argTypes).collect(Collectors.joining(".class, ", "new Class<?>[]{", ".class}"));
            CodeBlock.Builder argNameArrayBuilder = CodeBlock.builder();
            argNameArrayBuilder.add("new $T{ ", new Object[]{ArrayTypeName.of(String.class)});
            boolean first = true;
            for (String argName : argNames) {
                if (first) {
                    first = false;
                } else {
                    argNameArrayBuilder.add(", ", new Object[0]);
                }
                argNameArrayBuilder.add("$S", new Object[]{argName});
            }
            argNameArrayBuilder.add(" }", new Object[0]);
            argNamesString = argNameArrayBuilder.build().toString();
        }
        if (SourceVersion.isKeyword(constantName)) {
            constantName = constantName + "_";
        }
        this.typeSpecBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(DeclaredMessageKey.class), (String)constantName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T($T.class, $S, $L, $L)", new Object[]{DeclaredMessageKey.class, ClassName.get((TypeElement)this.owningTypeElement), code, argTypesString, argNamesString}).build());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)constantName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get(ResolvableMessage.class));
        if (argTypes != null) {
            for (i = 0; i < argTypes.length; ++i) {
                String argType = argTypes[i];
                String argName = argNames[i];
                ClassName argTypeName = argType.contains(".") ? ClassName.bestGuess((String)argType) : ClassName.get((String)"", (String)argType, (String[])new String[0]);
                String paramName = argName == null ? "arg" + i : argName;
                method.addParameter((TypeName)argTypeName, paramName, new Modifier[0]);
            }
        }
        if (argTypes != null) {
            method.addCode("return $T.forCode($S)", new Object[]{ResolvableMessage.class, code});
            for (i = 0; i < argTypes.length; ++i) {
                String argName = argNames[i];
                String paramName = argName == null ? "arg" + i : argName;
                method.addCode(".arg($S, $L)", new Object[]{argName, paramName});
            }
            method.addCode(".build();\n", new Object[0]);
        } else {
            method.addStatement("return $T.forCodeNoArgs($S)", new Object[]{ResolvableMessage.class, code});
        }
        this.typeSpecBuilder.addMethod(method.build());
    }

    public void writeTo(Filer filer) throws IOException {
        TypeSpec typeSpec = this.typeSpecBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).build();
        javaFile.writeTo(filer);
    }
}

