package de.codecamp.messages.processor;

import java.io.IOException;

import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.MethodSpec.Builder;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;

import de.codecamp.ProcessorUtils;
import de.codecamp.messages.codegen.MessageCodegenUtils;
import de.codecamp.messages.codegen.MessageProxyInterface;
import de.codecamp.messages.codegen.MessageProxyMethod;
import de.codecamp.messages.codegen.MessageProxyParam;


public class MessageProxyFileBuilder
{

  private TypeElement owningTypeElement;

  private String packageName;

  private String constantsSimpleTypeName;

  private TypeSpec.Builder typeSpecBuilder;


  public MessageProxyFileBuilder(TypeElement owningTypeElement, ClassName generatedAnntation)
  {
    this.owningTypeElement = owningTypeElement;

    this.packageName = ProcessorUtils.getPackage(owningTypeElement).getQualifiedName().toString();
    this.constantsSimpleTypeName = MessageCodegenUtils.getMessageProxiesSimpleTypeNameFor(
        MessageKeyProcessor.getMessageOwnerSimpleClassName(owningTypeElement));

    initBuilder(generatedAnntation);
  }


  private void initBuilder(ClassName generatedAnntation)
  {
    typeSpecBuilder =
        TypeSpec.interfaceBuilder(constantsSimpleTypeName).addModifiers(Modifier.PUBLIC);

    if (generatedAnntation != null)
    {
      AnnotationSpec generatedAtSpec = AnnotationSpec.builder(generatedAnntation)
          .addMember("value", "$S", MessageKeyProcessor.class.getName()).build();
      typeSpecBuilder.addAnnotation(generatedAtSpec);
    }

    AnnotationSpec messageProxyAtSpec = AnnotationSpec.builder(MessageProxyInterface.class)
        .addMember("sourceType", "$T.class", ClassName.get(owningTypeElement)).build();
    typeSpecBuilder.addAnnotation(messageProxyAtSpec);
  }


  public TypeSpec.Builder getTypeSpecBuilder()
  {
    return typeSpecBuilder;
  }

  public String getConstantsSimpleTypeName()
  {
    return constantsSimpleTypeName;
  }


  public void addMessageMethod(String constantName, String messageKey, String[] argTypes,
      String[] argNames)
  {
    AnnotationSpec messageProxyMethodAtSpec = AnnotationSpec.builder(MessageProxyMethod.class)
        .addMember("code", "$S", messageKey).build();

    Builder methodBuilder =
        MethodSpec.methodBuilder(constantName).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT)
            .addAnnotation(messageProxyMethodAtSpec).returns(String.class);

    if (argTypes != null)
    {
      for (int i = 0; i < argTypes.length; i++)
      {
        String argType = argTypes[i];
        String argName = argNames[i];

        TypeName argTypeName;
        if (argType.contains("."))
          argTypeName = ClassName.bestGuess(argType);
        else
          argTypeName = ClassName.get("", argType);

        String paramName = argName == null ? "arg" + i : argName;

        ParameterSpec.Builder builder = ParameterSpec.builder(argTypeName, paramName);
        if (argName != null)
          builder.addAnnotation(AnnotationSpec.builder(MessageProxyParam.class)
              .addMember("name", "$S", argName).build());
        methodBuilder.addParameter(builder.build());
      }
    }

    typeSpecBuilder.addMethod(methodBuilder.build());
  }

  public void writeTo(Filer filer)
    throws IOException
  {
    TypeSpec typeSpec = typeSpecBuilder.build();

    JavaFile javaFile = JavaFile.builder(packageName, typeSpec).build();

    javaFile.writeTo(filer);
  }

}
