package de.codecamp.messages.processor;

import java.util.Objects;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

import org.apache.commons.lang3.ArrayUtils;

import de.codecamp.messages.MessageKeyUtils;
import de.codecamp.messages.MessageKeyWithArgs;


public class ProcessedMessageKey
  implements
    MessageKeyWithArgs,
    Comparable<ProcessedMessageKey>
{

  private final Element sourceElement;

  private final TypeElement owningTypeElement;

  private final String prefix;

  private final String localPart;

  private final String[] argTypes;

  private final String[] argNames;


  public ProcessedMessageKey(Element sourceElement, TypeElement owningTypeElement, String prefix,
      String localPart)
  {
    this(sourceElement, owningTypeElement, prefix, localPart, null, null);
  }

  public ProcessedMessageKey(Element sourceElement, TypeElement owningTypeElement, String prefix,
      String localPart, String[] argTypes, String[] argNames)
  {
    if (sourceElement == null)
      throw new IllegalArgumentException("sourceElement required");

    this.sourceElement = sourceElement;
    this.owningTypeElement = owningTypeElement;
    this.prefix = prefix;
    this.localPart = localPart;
    this.argTypes = argTypes;
    this.argNames = argNames;
  }


  public Element getSourceElement()
  {
    return sourceElement;
  }

  public TypeElement getOwningTypeElement()
  {
    return owningTypeElement;
  }

  public String getPrefix()
  {
    return prefix;
  }

  public String getLocalPart()
  {
    return localPart;
  }

  @Override
  public String getCode()
  {
    return MessageKeyUtils.getKeyFor(prefix, localPart);
  }

  @Override
  public boolean hasArgs()
  {
    return ArrayUtils.isNotEmpty(argTypes);
  }

  public int getArgCount()
  {
    if (!hasArgs())
      return 0;

    return argTypes.length;
  }

  @Override
  public String[] getArgTypes()
  {
    return argTypes;
  }

  @Override
  public String[] getArgNames()
  {
    return argNames;
  }


  @Override
  public int compareTo(ProcessedMessageKey o)
  {
    return toString().compareTo(o.toString());
  }

  @Override
  public int hashCode()
  {
    return toString().hashCode();
  }

  @Override
  public boolean equals(Object obj)
  {
    if (obj == null)
      return false;
    if (obj == this)
      return true;

    if (!(obj instanceof ProcessedMessageKey))
      return false;

    ProcessedMessageKey other = (ProcessedMessageKey) obj;
    return other.getPrefix().equals(getPrefix())
        && Objects.equals(other.getLocalPart(), getLocalPart());
  }

  @Override
  public String toString()
  {
    return getCode();
  }

}
