/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp;

import java.beans.Introspector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class ProcessorUtils {
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>(Arrays.asList("class"));
    private ProcessingEnvironment processingEnv;

    public ProcessorUtils(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public String getOption(String name) {
        return this.processingEnv.getOptions().get(name);
    }

    public String getOption(String name, String defaultValue) {
        String value = this.getOption(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = defaultValue;
        }
        return value;
    }

    public Boolean getOptionAsBoolean(String name) {
        return Boolean.valueOf(this.getOption(name));
    }

    public Boolean getOptionAsBoolean(String name, Boolean defaultValue) {
        Boolean value = this.getOptionAsBoolean(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public List<String> getOptionAsList(String name) {
        String rawValue = this.processingEnv.getOptions().get(name);
        if (rawValue == null) {
            return null;
        }
        return Stream.of(StringUtils.splitPreserveAllTokens((String)rawValue, (String)",")).map(String::trim).collect(Collectors.toList());
    }

    public List<String> getOptionAsList(String name, List<String> defaultValues) {
        List<String> value = this.getOptionAsList(name);
        if (value == null || value.isEmpty()) {
            value = defaultValues;
        }
        return value;
    }

    public <T extends Enum<T>> T getOptionAsEnum(String name, Class<T> enumType) {
        String value = this.getOption(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return Enum.valueOf(enumType, value);
    }

    public <T extends Enum<T>> T getOptionAsEnum(String name, Class<T> enumType, T defaultValue) {
        T e = this.getOptionAsEnum(name, enumType);
        if (e == null) {
            e = defaultValue;
        }
        return e;
    }

    public static TypeElement getGeneratedAnnotation(Elements elements, SourceVersion sourceVersion) {
        TypeElement typeElement = null;
        typeElement = elements.getTypeElement("javax.annotation.processing.Generated");
        if (typeElement == null) {
            typeElement = elements.getTypeElement("javax.annotation.Generated");
        }
        return typeElement;
    }

    public static PackageElement getPackage(Element element) {
        while (element != null && element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    public static List<ExecutableElement> getDeclaredMethods(TypeElement element) {
        return ElementFilter.methodsIn(element.getEnclosedElements());
    }

    public static List<VariableElement> getDeclaredFields(TypeElement element) {
        return ElementFilter.fieldsIn(element.getEnclosedElements());
    }

    public static List<VariableElement> getEnumConstants(TypeElement enumTypeElement) {
        if (enumTypeElement.getKind() != ElementKind.ENUM) {
            throw new IllegalArgumentException("not an enum: " + enumTypeElement.getQualifiedName());
        }
        return ElementFilter.fieldsIn(enumTypeElement.getEnclosedElements()).stream().filter(ve -> ve.getKind() == ElementKind.ENUM_CONSTANT).collect(Collectors.toList());
    }

    public static List<TypeElement> getTypeNesting(TypeElement typeElement) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        while (typeElement != null) {
            result.add(0, typeElement);
            typeElement = ProcessorUtils.getEnclosingTypeElement(typeElement);
        }
        return result;
    }

    public static TypeElement getEnclosingTypeElement(Element element) {
        while ((element = element.getEnclosingElement()) != null && !element.getKind().isClass() && !element.getKind().isInterface()) {
        }
        return (TypeElement)element;
    }

    public Set<? extends Element> getElementsAnnotatedWith(RoundEnvironment roundEnv, Class<? extends Annotation> annotationType) {
        HashSet<Element> result = new HashSet<Element>();
        result.addAll(roundEnv.getElementsAnnotatedWith(annotationType));
        Repeatable repeatableAt = annotationType.getAnnotation(Repeatable.class);
        if (repeatableAt != null) {
            result.addAll(roundEnv.getElementsAnnotatedWith(repeatableAt.value()));
        }
        return result;
    }

    public static AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annotationType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationType.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public Set<AnnotationMirror> getAnnotationMirrors(Element element, Class<? extends Annotation> annotationType) {
        Class<? extends Annotation> containerAnnotationType = null;
        Repeatable repeatableAt = annotationType.getAnnotation(Repeatable.class);
        if (repeatableAt != null) {
            containerAnnotationType = repeatableAt.value();
        }
        HashSet<AnnotationMirror> result = new HashSet<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (containerAnnotationType != null && annotationMirror.getAnnotationType().toString().equals(containerAnnotationType.getCanonicalName())) {
                result.addAll(this.getAnnotationValueAsAnnotationMirrors(annotationMirror, "value"));
                continue;
            }
            if (!annotationMirror.getAnnotationType().toString().equals(annotationType.getName())) continue;
            result.add(annotationMirror);
        }
        return result;
    }

    public AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public <T> T getAnnotationValueAs(AnnotationMirror annotationMirror, String key, Class<T> type, T defaultValue) {
        AnnotationValue annotationValue = this.getAnnotationValue(annotationMirror, key);
        Object value = annotationValue != null ? annotationValue.getValue() : defaultValue;
        return type.cast(value);
    }

    public <T> List<T> getAnnotationValuesAs(AnnotationMirror annotationMirror, String key, Class<T> listElementType) {
        List<AnnotationValue> annotationValues = this.getAnnotationValues(annotationMirror, key);
        if (annotationValues == null) {
            return null;
        }
        return annotationValues.stream().map(av -> listElementType.cast(av.getValue())).collect(Collectors.toList());
    }

    public List<AnnotationValue> getAnnotationValues(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            AnnotationValue annotationValue = this.getAnnotationValue(annotationMirror, key);
            return (List)annotationValue.getValue();
        }
        return Collections.emptyList();
    }

    public TypeElement getAnnotationValueAsType(AnnotationMirror annotationMirror, String key) {
        AnnotationValue annotationValue = this.getAnnotationValue(annotationMirror, key);
        if (annotationValue == null) {
            return null;
        }
        TypeMirror typeMirror = (TypeMirror)annotationValue.getValue();
        if (typeMirror == null) {
            return null;
        }
        return (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
    }

    public List<TypeElement> getAnnotationValueAsTypes(AnnotationMirror annotationMirror, String key) {
        List<AnnotationValue> values = this.getAnnotationValues(annotationMirror, key);
        if (values == null) {
            return null;
        }
        return values.stream().map(av -> (TypeElement)this.processingEnv.getTypeUtils().asElement((TypeMirror)av.getValue())).collect(Collectors.toList());
    }

    public List<AnnotationMirror> getAnnotationValueAsAnnotationMirrors(AnnotationMirror annotationMirror, String key) {
        List<AnnotationValue> values = this.getAnnotationValues(annotationMirror, key);
        if (values == null) {
            return null;
        }
        return values.stream().map(av -> (AnnotationMirror)av.getValue()).collect(Collectors.toList());
    }

    public static <A extends TypeElement> Set<A> findComposedAnnotationTypes(Set<A> processedAnnotations, Class<? extends Annotation> metaAnnotationType, boolean includeMetaAnnotation) {
        HashSet<TypeElement> annotations = new HashSet<TypeElement>();
        for (TypeElement annotationElement : processedAnnotations) {
            if ((!includeMetaAnnotation || !annotationElement.getQualifiedName().toString().equals(metaAnnotationType.getName())) && annotationElement.getAnnotation(metaAnnotationType) == null) continue;
            annotations.add(annotationElement);
        }
        return annotations;
    }

    public static <A extends Annotation> A findMetaAnnotation(Element element, Class<A> annotationType) {
        List<A> metaAnnotations = ProcessorUtils.findMetaAnnotations(element, annotationType);
        if (!metaAnnotations.isEmpty()) {
            return (A)((Annotation)metaAnnotations.get(0));
        }
        return null;
    }

    public static <A extends Annotation> List<A> findMetaAnnotations(Element element, Class<A> annotationType) {
        ArrayList<A> result = new ArrayList<A>();
        A annotation = element.getAnnotation(annotationType);
        if (annotation != null) {
            result.add(annotation);
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            annotation = annotationMirror.getAnnotationType().asElement().getAnnotation(annotationType);
            if (annotation == null) continue;
            result.add(annotation);
        }
        return result;
    }

    public static <A extends Annotation> Map<AnnotationMirror, A> findMetaAnnotationsWithSource(Element element, Class<A> annotationType) {
        LinkedHashMap<AnnotationMirror, A> result = new LinkedHashMap<AnnotationMirror, A>();
        AnnotationMirror mirror = ProcessorUtils.getAnnotationMirror(element, annotationType);
        A annotation = element.getAnnotation(annotationType);
        if (mirror != null && annotation != null) {
            result.put(mirror, annotation);
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element directAnnotationElement = annotationMirror.getAnnotationType().asElement();
            mirror = ProcessorUtils.getAnnotationMirror(directAnnotationElement, annotationType);
            annotation = directAnnotationElement.getAnnotation(annotationType);
            if (mirror == null || annotation == null) continue;
            result.put(mirror, annotation);
        }
        return result;
    }

    public Path getSourceOutputPath() {
        return this.getOutputPath(StandardLocation.SOURCE_OUTPUT);
    }

    public Path getClassOutputPath() {
        return this.getOutputPath(StandardLocation.CLASS_OUTPUT);
    }

    private Path getOutputPath(JavaFileManager.Location location) {
        try {
            FileObject resource = this.processingEnv.getFiler().createResource(location, "", UUID.randomUUID().toString(), new Element[0]);
            resource.delete();
            return Paths.get(resource.toUri()).getParent();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<Triple<String, String, ExecutableElement>> findBeanProperties(TypeElement beanTypeElement) {
        List<ExecutableElement> methodElements = ProcessorUtils.getDeclaredMethods(beanTypeElement);
        ArrayList<Triple<String, String, ExecutableElement>> properties = new ArrayList<Triple<String, String, ExecutableElement>>();
        for (ExecutableElement methodElement : methodElements) {
            String methodName;
            if (!methodElement.getModifiers().contains((Object)Modifier.PUBLIC) || methodElement.getModifiers().contains((Object)Modifier.STATIC) || methodElement.getReturnType().getKind() == TypeKind.VOID || !methodElement.getParameters().isEmpty() || !(methodName = methodElement.getSimpleName().toString()).startsWith(GET_PREFIX) && !methodName.startsWith(IS_PREFIX)) continue;
            String propertyName = methodName.startsWith(GET_PREFIX) ? methodName.substring(GET_PREFIX.length()) : methodName.substring(IS_PREFIX.length());
            if (IGNORED_PROPERTIES.contains(propertyName = Introspector.decapitalize(propertyName))) continue;
            properties.add((Triple<String, String, ExecutableElement>)Triple.of((Object)propertyName, null, (Object)methodElement));
        }
        return properties;
    }
}

