/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.processor;

import de.codecamp.messages.MessageKeyUtils;
import de.codecamp.messages.MessageKeyWithArgs;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class ProcessedMessageKey
implements MessageKeyWithArgs,
Comparable<ProcessedMessageKey> {
    private static final String[] EMPTY_ARG_ARRAY = new String[0];
    private final Element sourceElement;
    private final TypeElement owningTypeElement;
    private final String prefix;
    private final String localPart;
    private final String[] argTypes;
    private final String[] argNames;

    public ProcessedMessageKey(Element sourceElement, TypeElement owningTypeElement, String prefix, String localPart, String[] argTypes, String[] argNames) {
        Objects.requireNonNull(sourceElement, "sourceElement must not be null");
        Objects.requireNonNull(prefix, "prefix must not be null");
        Objects.requireNonNull(localPart, "localPart must not be null");
        this.sourceElement = sourceElement;
        this.owningTypeElement = owningTypeElement;
        this.prefix = prefix;
        this.localPart = localPart;
        this.argTypes = argTypes == null ? null : (String[])argTypes.clone();
        this.argNames = argNames == null ? null : (String[])argNames.clone();
    }

    public Element getSourceElement() {
        return this.sourceElement;
    }

    public TypeElement getOwningTypeElement() {
        return this.owningTypeElement;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getCode() {
        return MessageKeyUtils.getKeyFor((String)this.prefix, (String)this.localPart);
    }

    public boolean hasArgs() {
        return this.argTypes != null && this.argTypes.length > 0;
    }

    public int getArgCount() {
        if (!this.hasArgs()) {
            return 0;
        }
        return this.argTypes.length;
    }

    public String[] getArgTypes() {
        if (this.hasArgs()) {
            return (String[])this.argTypes.clone();
        }
        return EMPTY_ARG_ARRAY;
    }

    public String[] getArgNames() {
        if (this.hasArgs()) {
            return (String[])this.argNames.clone();
        }
        return EMPTY_ARG_ARRAY;
    }

    @Override
    public int compareTo(ProcessedMessageKey o) {
        return this.toString().compareTo(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProcessedMessageKey)) {
            return false;
        }
        ProcessedMessageKey other = (ProcessedMessageKey)obj;
        return other.getPrefix().equals(this.getPrefix()) && Objects.equals(other.getLocalPart(), this.getLocalPart());
    }

    public String toString() {
        return this.getCode();
    }
}

