/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.processor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.apache.commons.lang3.StringUtils;

public class ProcessorUtils {
    private final ProcessingEnvironment processingEnv;

    public ProcessorUtils(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public String getOption(String name) {
        return this.processingEnv.getOptions().get(name);
    }

    public String getOption(String name, String defaultValue) {
        String value = this.getOption(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = defaultValue;
        }
        return value;
    }

    public Boolean getOptionAsBoolean(String name) {
        return Boolean.valueOf(this.getOption(name));
    }

    public Boolean getOptionAsBoolean(String name, Boolean defaultValue) {
        Boolean value = this.getOptionAsBoolean(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public List<String> getOptionAsList(String name) {
        String rawValue = this.processingEnv.getOptions().get(name);
        if (rawValue == null) {
            return null;
        }
        return Stream.of(StringUtils.splitPreserveAllTokens((String)rawValue, (String)",")).map(String::trim).collect(Collectors.toList());
    }

    public List<String> getOptionAsList(String name, List<String> defaultValues) {
        List<String> value = this.getOptionAsList(name);
        if (value == null || value.isEmpty()) {
            value = defaultValues;
        }
        return value;
    }

    public <T extends Enum<T>> T getOptionAsEnum(String name, Class<T> enumType) {
        String value = this.getOption(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return Enum.valueOf(enumType, value);
    }

    public <T extends Enum<T>> T getOptionAsEnum(String name, Class<T> enumType, T defaultValue) {
        T e = this.getOptionAsEnum(name, enumType);
        if (e == null) {
            e = defaultValue;
        }
        return e;
    }

    public Optional<TypeElement> getGeneratedAnnotation() {
        return Optional.ofNullable(this.processingEnv.getElementUtils().getTypeElement("javax.annotation.processing.Generated"));
    }

    public static Set<? extends Element> getElementsAnnotatedWith(RoundEnvironment roundEnv, Class<? extends Annotation> annotationType) {
        HashSet<Element> result = new HashSet<Element>();
        result.addAll(roundEnv.getElementsAnnotatedWith(annotationType));
        Repeatable repeatableAt = annotationType.getAnnotation(Repeatable.class);
        if (repeatableAt != null) {
            result.addAll(roundEnv.getElementsAnnotatedWith(repeatableAt.value()));
        }
        return result;
    }

    public Path getSourceOutputPath() {
        return this.getOutputPath(StandardLocation.SOURCE_OUTPUT);
    }

    public Path getClassOutputPath() {
        return this.getOutputPath(StandardLocation.CLASS_OUTPUT);
    }

    private Path getOutputPath(JavaFileManager.Location location) {
        try {
            FileObject resource = this.processingEnv.getFiler().createResource(location, "", UUID.randomUUID().toString(), new Element[0]);
            resource.delete();
            return Paths.get(resource.toUri()).getParent();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

