/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.bundle;

import de.codecamp.messages.shared.bundle.BundleException;
import de.codecamp.messages.shared.bundle.BundleFile;
import de.codecamp.messages.shared.bundle.FileSystemAdapter;
import de.codecamp.messages.shared.conf.ProjectConf;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class MessageBundleManager<D, F> {
    public static final String PROPERTIES_EXT = "properties";
    private final ProjectConf projectConf;
    private final FileSystemAdapter<D, F> fileSystem;
    private final D bundleDir;
    private final boolean flatBundleDir = false;
    private Map<F, BundleFile<F>> bundleFiles = new HashMap<F, BundleFile<F>>();

    public MessageBundleManager(ProjectConf projectConf, FileSystemAdapter<D, F> fileSystem) {
        List<F> files;
        if (projectConf == null) {
            throw new IllegalArgumentException("projectConf must not be null");
        }
        this.projectConf = projectConf;
        this.fileSystem = fileSystem;
        this.bundleDir = fileSystem.getDirectory(projectConf.getBundleDir());
        if (this.bundleDir == null) {
            throw new IllegalStateException("Bundle directory not found or not configured correctly.");
        }
        try {
            files = fileSystem.listFiles(this.getBundleDir(), true);
        }
        catch (Exception ex) {
            String msg = "Failed to list all message bundle files in '%s'.";
            msg = String.format(msg, this.getBundleDir());
            throw new BundleException(msg, ex);
        }
        for (F file : files) {
            if (!fileSystem.getFileName(file).endsWith(".properties") || MessageBundleManager.toBundleFileCoordinates(fileSystem, this.bundleDir, file) == null) continue;
            this.prepareBundleFile(file, false);
        }
    }

    public static <F> BundleFileCoordinates toBundleFileCoordinates(String fileName) {
        Locale locale;
        String bundleName;
        String name = StringUtils.removeEnd((String)fileName, (String)".properties");
        int i = StringUtils.lastIndexOf((CharSequence)name, (CharSequence)".");
        if (i < 0) {
            i = 0;
        }
        if ((i = StringUtils.indexOf((CharSequence)name, (CharSequence)"_", (int)i)) >= 0) {
            bundleName = StringUtils.substring((String)name, (int)0, (int)i);
            String localeString = name.substring(i + 1);
            try {
                locale = LocaleUtils.toLocale((String)localeString);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        } else {
            bundleName = name;
            locale = Locale.ROOT;
        }
        bundleName = bundleName.replace("/", ".").replace("\\", ".");
        return new BundleFileCoordinates(bundleName, locale);
    }

    private static <D, F> BundleFileCoordinates toBundleFileCoordinates(FileSystemAdapter<D, F> fileSystem, D bundleDir, F file) {
        return MessageBundleManager.toBundleFileCoordinates(fileSystem.getRelativeFilePath(bundleDir, file));
    }

    private D getBundleDir() {
        return this.bundleDir;
    }

    public Set<String> getBundleNames() {
        return this.bundleFiles.values().stream().map(BundleFile::getBundleName).filter(bundleName -> !this.projectConf.getIgnoredBundles().contains(bundleName)).collect(Collectors.toSet());
    }

    public boolean bundleExists(String bundleName) {
        return this.getBundleNames().contains(bundleName);
    }

    public boolean isReadOnly(String bundleName) {
        return this.projectConf.getIgnoredBundles().contains(bundleName);
    }

    public BundleFile<F> getBundleFile(String bundleName, Locale locale) {
        return this.getBundleFile(bundleName, locale, false);
    }

    public BundleFile<F> getBundleFile(String bundleName, Locale locale, boolean create) {
        BundleFile<F> bundleFile = this.bundleFiles.values().stream().filter(file -> file.getBundleName().equals(bundleName) && Objects.equals(file.getLocale(), locale)).findAny().orElse(null);
        if (bundleFile == null && create) {
            Object bundleFileName = bundleName.replace('.', '/');
            if (!Locale.ROOT.equals(locale)) {
                bundleFileName = (String)bundleFileName + "_" + locale.toString();
            }
            bundleFileName = (String)bundleFileName + ".properties";
            F file2 = this.fileSystem.getFile(this.getBundleDir(), (String)bundleFileName);
            bundleFile = this.prepareBundleFile(file2, true);
        } else if (bundleFile != null) {
            bundleFile.ensureLoaded();
        }
        return bundleFile;
    }

    public BundleFile<F> getBundleFileAt(F fileLocation) {
        BundleFile<F> bundleFile = this.bundleFiles.get(fileLocation);
        if (bundleFile != null) {
            bundleFile.ensureLoaded();
        }
        return bundleFile;
    }

    public Set<BundleFile<F>> getBundleFiles() {
        return this.getBundleFiles(false);
    }

    public Set<BundleFile<F>> getBundleFiles(boolean includeIgnored) {
        Stream<BundleFile<F>> bundleStream = this.bundleFiles.values().stream();
        if (!includeIgnored) {
            bundleStream = bundleStream.filter(file -> !this.projectConf.getIgnoredBundles().contains(file.getBundleName()));
        }
        return bundleStream.filter(bf -> {
            try {
                bf.ensureLoaded();
            }
            catch (BundleException ex) {
                return false;
            }
            return true;
        }).sorted().collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    public Set<BundleFile<F>> getBundleFiles(String bundleName) {
        return this.bundleFiles.values().stream().filter(file -> Objects.equals(file.getBundleName(), bundleName)).peek(BundleFile::ensureLoaded).collect(Collectors.toSet());
    }

    public Set<BundleFile<F>> getBundleFiles(Locale locale) {
        return this.bundleFiles.values().stream().filter(file -> Objects.equals(file.getLocale(), locale)).peek(BundleFile::ensureLoaded).collect(Collectors.toSet());
    }

    private BundleFile<F> prepareBundleFile(F bundleFilePath, boolean load) {
        BundleFile<F> bundleFile = this.bundleFiles.get(bundleFilePath);
        if (bundleFile == null) {
            BundleFileCoordinates coordinates = MessageBundleManager.toBundleFileCoordinates(this.fileSystem, this.bundleDir, bundleFilePath);
            if (coordinates == null) {
                throw new BundleException(String.format("Not a message bundle file: %s", bundleFilePath));
            }
            bundleFile = new BundleFile<F>(this.fileSystem, bundleFilePath, this.projectConf.getBundleEncoding(), coordinates, this.fileSystem.getDisplayPath(this.getBundleDir(), bundleFilePath));
            if (this.projectConf.getIgnoredBundles().contains(bundleFile.getBundleName())) {
                bundleFile.setReadOnly(true);
            }
            if (load) {
                bundleFile.ensureLoaded();
            }
            this.bundleFiles.put(bundleFilePath, bundleFile);
        }
        return bundleFile;
    }

    public void setMessage(String messageKey, Locale locale, String message) {
        String targetBundleName = this.projectConf.toTargetBundleName(messageKey).orElseThrow(() -> new IllegalArgumentException("No target bundle configured for message key code '" + messageKey + "'."));
        this.getBundleFile(targetBundleName, locale, true).setMessage(messageKey, message);
    }

    public void removeMessage(String messageKey, Locale locale) {
        String targetBundleName = this.projectConf.toTargetBundleName(messageKey).orElseThrow(() -> new IllegalArgumentException("No target bundle configured for message key code '" + messageKey + "'."));
        BundleFile<F> bundleFile = this.getBundleFile(targetBundleName, locale, false);
        if (bundleFile != null) {
            bundleFile.removeMessage(messageKey);
        }
    }

    public void removeMessage(String messageKey) {
        String targetBundleName = this.projectConf.toTargetBundleName(messageKey).orElse(null);
        if (targetBundleName == null) {
            return;
        }
        boolean found = false;
        for (BundleFile<F> bundleFile : this.getBundleFiles(targetBundleName)) {
            String oldMessage = bundleFile.removeMessage(messageKey);
            if (oldMessage == null) continue;
            found = true;
        }
        if (!found) {
            for (BundleFile<F> bundleFile : this.getBundleFiles()) {
                if (bundleFile.getBundleName().equals(targetBundleName)) continue;
                bundleFile.removeMessage(messageKey);
            }
        }
    }

    public void save() throws BundleException {
        this.save(false);
    }

    public void save(boolean forceForSorting) throws BundleException {
        for (BundleFile<F> bundleFile : this.bundleFiles.values()) {
            if (!bundleFile.isLoaded() || bundleFile.isReadOnly()) continue;
            if (bundleFile.isEmpty()) {
                bundleFile.delete();
                continue;
            }
            bundleFile.save(forceForSorting && bundleFile.needsSorting());
        }
    }

    public static class BundleFileCoordinates {
        private final String bundleName;
        private final Locale locale;

        public BundleFileCoordinates(String bundleName, Locale locale) {
            this.bundleName = bundleName;
            this.locale = locale;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

