/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.model;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import de.codecamp.messages.shared.conf.BundleMapping;
import de.codecamp.messages.shared.model.AbstractPersistableData;
import de.codecamp.messages.shared.model.MessageKeyWithSourceLocation;
import de.codecamp.messages.shared.model.MessageModule;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;

public class MessageKeyIndex
extends AbstractPersistableData
implements MessageModule {
    private static final String FILE_NAME_PREFIX = "";
    private static final String FILE_NAME_SUFFIX = "_messagekeys.json";
    private String moduleName;
    private List<Locale> targetLocales = new ArrayList<Locale>();
    private List<BundleMapping> bundleMappings;
    private List<String> importedModules = new ArrayList<String>();
    private String messageFormat;
    private SortedSetMultimap<String, MessageKeyWithSourceLocation> keysPerType = TreeMultimap.create();
    private SortedMap<String, String> codegenPackagePerType = new TreeMap<String, String>();
    private volatile Map<String, MessageKeyWithSourceLocation> keyCache;

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public List<Locale> getTargetLocales() {
        return this.targetLocales;
    }

    public void setTargetLocales(List<Locale> targetLocales) {
        this.targetLocales = targetLocales;
    }

    @Override
    public List<BundleMapping> getBundleMappings() {
        return new ArrayList<BundleMapping>(this.bundleMappings);
    }

    public void setBundleMappings(List<BundleMapping> bundleMappings) {
        this.bundleMappings = bundleMappings;
    }

    @Override
    public List<String> getImportedModules() {
        return new ArrayList<String>(this.importedModules);
    }

    public void setImportedModules(List<String> importedModules) {
        this.importedModules = importedModules;
    }

    @Override
    public String getMessageFormat() {
        return this.messageFormat;
    }

    public void setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
    }

    public boolean containsKey(String key) {
        return this.keysPerType.values().stream().map(MessageKeyWithSourceLocation::getCode).filter(key::equals).findAny().isPresent();
    }

    public boolean hasSourceType(String sourceType) {
        return this.keysPerType.containsKey((Object)sourceType);
    }

    public Stream<String> getSourceTypes() {
        return this.keysPerType.keys().stream();
    }

    public int countSourceTypes() {
        return this.keysPerType.keys().size();
    }

    public Stream<MessageKeyWithSourceLocation> getKeysForType(String sourceType) {
        return this.keysPerType.get((Object)sourceType).stream();
    }

    public MessageKeyWithSourceLocation getKey(String code) {
        if (this.keyCache == null) {
            this.keyCache = new HashMap<String, MessageKeyWithSourceLocation>();
            for (MessageKeyWithSourceLocation messageKey : this.keysPerType.values()) {
                this.keyCache.put(messageKey.getCode(), messageKey);
            }
        }
        return this.keyCache.get(code);
    }

    public int countKeys(String sourceType) {
        return this.keysPerType.get((Object)sourceType).size();
    }

    public Stream<MessageKeyWithSourceLocation> getKeys() {
        return this.keysPerType.values().stream();
    }

    public int countKeys() {
        return this.keysPerType.values().size();
    }

    public void updateMessageKeysFor(String sourceType, Set<MessageKeyWithSourceLocation> messageKeys) {
        Set<Object> newKeysPlusLocation = messageKeys != null ? new HashSet<MessageKeyWithSourceLocation>(messageKeys) : Collections.emptySet();
        this.keysPerType.replaceValues((Object)sourceType, newKeysPlusLocation);
        this.keyCache = null;
    }

    public void updateCodegenPackageFor(String sourceType, String codegenPackage) {
        this.codegenPackagePerType.put(sourceType, codegenPackage);
    }

    public int getSize() {
        return this.keysPerType.size();
    }

    public String getCodegenPackage(String sourceType) {
        return (String)this.codegenPackagePerType.get(sourceType);
    }

    public String getPreferredFilePath() {
        if (this.moduleName == null) {
            throw new IllegalStateException("moduleName must be set");
        }
        return MessageKeyIndex.getPreferredFilePath(this.getModuleName());
    }

    public static String getPreferredFilePath(String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException("moduleName must be set");
        }
        return moduleName + FILE_NAME_SUFFIX;
    }

    public static boolean isIndexFile(String filename) {
        return filename.startsWith(FILE_NAME_PREFIX) && filename.endsWith(FILE_NAME_SUFFIX);
    }

    public static MessageKeyIndex readFrom(InputStream inputStream) throws AbstractPersistableData.PersistableDataException {
        return MessageKeyIndex.readFrom(inputStream, MessageKeyIndex.class);
    }

    public static MessageKeyIndex readFrom(Path path) throws AbstractPersistableData.PersistableDataException {
        return MessageKeyIndex.readFrom(path, MessageKeyIndex.class);
    }

    public static MessageKeyIndex copyOf(MessageKeyIndex index) {
        MessageKeyIndex copy = new MessageKeyIndex();
        copy.setModuleName(index.getModuleName());
        copy.setTargetLocales(index.getTargetLocales());
        copy.setBundleMappings(index.getBundleMappings());
        copy.setImportedModules(index.getImportedModules());
        copy.setMessageFormat(index.getMessageFormat());
        copy.keysPerType = TreeMultimap.create(index.keysPerType);
        return copy;
    }
}

