/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.conf;

import java.util.Objects;
import java.util.regex.Pattern;

public class BundleMapping {
    public static final BundleMapping IMPORTS_PLACEHOLDER = new BundleMapping(null, null);
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    private final String messageKeyPattern;
    private transient Pattern messageKeyPatternRegex;
    private final String bundleNamePattern;

    public BundleMapping(String messageKeyPattern, String bundleNamePattern) {
        this.messageKeyPattern = messageKeyPattern;
        this.bundleNamePattern = bundleNamePattern;
    }

    public String getMessageKeyPattern() {
        return this.messageKeyPattern;
    }

    public Pattern getMessageKeyPatternAsRegex() {
        if (this.messageKeyPatternRegex == null) {
            this.messageKeyPatternRegex = BundleMapping.toRegexPattern(this.messageKeyPattern);
        }
        return this.messageKeyPatternRegex;
    }

    public String getBundleNamePattern() {
        return this.bundleNamePattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messageKeyPattern == null ? 0 : this.messageKeyPattern.hashCode());
        result = 31 * result + (this.bundleNamePattern == null ? 0 : this.bundleNamePattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleMapping other = (BundleMapping)obj;
        if (!Objects.equals(this.messageKeyPattern, other.messageKeyPattern)) {
            return false;
        }
        return Objects.equals(this.bundleNamePattern, other.bundleNamePattern);
    }

    private static Pattern toRegexPattern(String messageKeyPattern) {
        if (messageKeyPattern.isEmpty()) {
            return MATCH_ALL;
        }
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("^");
        boolean firstSegment = true;
        for (String segment : messageKeyPattern.split("\\.")) {
            if (firstSegment) {
                firstSegment = false;
            } else {
                patternBuilder.append(Pattern.quote("."));
            }
            for (String token : segment.split("(?<=\\*+)(?!\\*)|(?<!\\*)(?=\\*+)")) {
                if (token.charAt(0) == '*') {
                    if (token.length() == 1) {
                        patternBuilder.append("[^\\.]*");
                        continue;
                    }
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append(Pattern.quote(token));
            }
        }
        patternBuilder.append("(\\..*)");
        patternBuilder.append("$");
        return Pattern.compile(patternBuilder.toString());
    }
}

