package de.codecamp.messages.shared.bundle;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;


public interface FileSystemAdapter<D, F>
{

  D getDirectory(String path);

  List<F> listFiles(D dir, boolean recursive)
    throws Exception;

  F getFile(D dir, String fileName);


  String getFileName(F file);

  String getRelativeFilePath(D dir, F file);

  String getDisplayPath(D dir, F file);

  boolean exists(F file);

  void createParentDirectories(F file)
    throws Exception;

  void deleteIfExists(F file)
    throws Exception;

  InputStream newInputStream(F file)
    throws Exception;

  OutputStream newOutputStream(F file)
    throws Exception;

}
