/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPersistableData {
    private static final Gson GSON;

    public void writeTo(OutputStream outputStream) throws PersistableDataException {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
            writer.flush();
        }
        catch (IOException ex) {
            throw new PersistableDataException(ex);
        }
    }

    public void writeTo(Path path) throws PersistableDataException {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                this.writeTo(out);
            }
        }
        catch (IOException ex) {
            throw new PersistableDataException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static <T> T readFrom(InputStream inputStream, Class<T> type) throws PersistableDataException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            Object object = GSON.fromJson((Reader)reader, type);
            return (T)object;
        }
        catch (JsonIOException | JsonSyntaxException | IOException ex) {
            throw new PersistableDataException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static <T> T readFrom(Path path, Class<T> type) throws PersistableDataException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            T t = AbstractPersistableData.readFrom(in, type);
            return t;
        }
        catch (JsonIOException | JsonSyntaxException | IOException ex) {
            throw new PersistableDataException(ex);
        }
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(SortedSetMultimap.class, (Object)new SortedSetMultimapSerializer());
        gsonBuilder.registerTypeAdapter(SetMultimap.class, (Object)new SetMultimapSerializer());
        gsonBuilder.registerTypeAdapter(Instant.class, (Object)new InstantSerializer());
        gsonBuilder.registerTypeAdapter(Locale.class, (Object)new LocaleSerializer());
        GSON = gsonBuilder.create();
    }

    public static class PersistableDataException
    extends Exception {
        public PersistableDataException(String message) {
            super(message);
        }

        public PersistableDataException(Throwable cause) {
            super(cause);
        }

        public PersistableDataException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class SortedSetMultimapSerializer
    implements JsonSerializer<SortedSetMultimap>,
    JsonDeserializer<SortedSetMultimap> {
        private SortedSetMultimapSerializer() {
        }

        public JsonElement serialize(SortedSetMultimap src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.asMap(), Map.class);
        }

        public SortedSetMultimap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ParameterizedType multimapTypeParams = (ParameterizedType)typeOfT;
            Type keyType = multimapTypeParams.getActualTypeArguments()[0];
            Type valueSetType = TypeToken.getParameterized(Set.class, (Type[])new Type[]{multimapTypeParams.getActualTypeArguments()[1]}).getType();
            Type serMapType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{keyType, valueSetType}).getType();
            Map map = (Map)context.deserialize(json, serMapType);
            TreeMultimap multimap = TreeMultimap.create();
            map.forEach((arg_0, arg_1) -> ((SortedSetMultimap)multimap).putAll(arg_0, arg_1));
            return multimap;
        }
    }

    private static class SetMultimapSerializer
    implements JsonSerializer<SetMultimap>,
    JsonDeserializer<SetMultimap> {
        private SetMultimapSerializer() {
        }

        public JsonElement serialize(SetMultimap src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.asMap(), Map.class);
        }

        public SetMultimap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ParameterizedType multimapTypeParams = (ParameterizedType)typeOfT;
            Type keyType = multimapTypeParams.getActualTypeArguments()[0];
            Type valueSetType = TypeToken.getParameterized(Set.class, (Type[])new Type[]{multimapTypeParams.getActualTypeArguments()[1]}).getType();
            Type serMapType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{keyType, valueSetType}).getType();
            Map map = (Map)context.deserialize(json, serMapType);
            HashMultimap multimap = HashMultimap.create();
            map.forEach((arg_0, arg_1) -> ((SetMultimap)multimap).putAll(arg_0, arg_1));
            return multimap;
        }
    }

    private static class InstantSerializer
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        private InstantSerializer() {
        }

        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)DateTimeFormatter.ISO_INSTANT.format(src));
        }

        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String instantString = (String)context.deserialize(json, String.class);
            return DateTimeFormatter.ISO_INSTANT.parse((CharSequence)instantString, Instant::from);
        }
    }

    private static class LocaleSerializer
    implements JsonSerializer<Locale>,
    JsonDeserializer<Locale> {
        private LocaleSerializer() {
        }

        public JsonElement serialize(Locale src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.toLanguageTag());
        }

        public Locale deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String languageTag = (String)context.deserialize(json, String.class);
            return Locale.forLanguageTag(languageTag);
        }
    }
}

