/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.messageformat;

import com.ibm.icu.util.CurrencyAmount;
import de.codecamp.messages.MessageKeyWithArgs;
import de.codecamp.messages.shared.conf.ProjectConf;
import de.codecamp.messages.shared.messageformat.DefaultMessageFormatSupport;
import de.codecamp.messages.shared.messageformat.IcuMessageFormatSupport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public interface MessageFormatSupport {
    public boolean supportsFormat(String var1);

    public boolean hasArgNameSupport();

    default public String formatArgType(String argType) {
        if (String.class.getName().equals(argType)) {
            return "text";
        }
        if (Byte.TYPE.getName().equals(argType) || Byte.class.getName().equals(argType) || Short.TYPE.getName().equals(argType) || Short.class.getName().equals(argType) || Integer.TYPE.getName().equals(argType) || Integer.class.getName().equals(argType) || Long.TYPE.getName().equals(argType) || Long.class.getName().equals(argType) || BigInteger.class.getName().equals(argType)) {
            return "integer";
        }
        if (Float.TYPE.getName().equals(argType) || Float.class.getName().equals(argType) || Double.TYPE.getName().equals(argType) || Double.class.getName().equals(argType) || BigDecimal.class.getName().equals(argType)) {
            return "decimal";
        }
        if (Date.class.getName().equals(argType) || Calendar.class.getName().equals(argType) || LocalDateTime.class.getName().equals(argType) || ZonedDateTime.class.getName().equals(argType) || OffsetDateTime.class.getName().equals(argType) || Instant.class.getName().equals(argType)) {
            return "date/time";
        }
        if (LocalDate.class.getName().equals(argType)) {
            return "date";
        }
        if (LocalTime.class.getName().equals(argType) || OffsetTime.class.getName().equals(argType)) {
            return "time";
        }
        if (CurrencyAmount.class.getName().equals(argType)) {
            return "currency";
        }
        return StringUtils.removeStart((String)argType, (String)"java.lang.");
    }

    public List<ArgInsert> getArgInsertOptions(MessageKeyWithArgs var1);

    public String createMessageBundleComment(MessageKeyWithArgs var1);

    public List<String> checkMessage(String var1, String[] var2, String[] var3, TypeChecker var4);

    public static MessageFormatSupport getSupport(ProjectConf projectConf) {
        MessageFormatSupport argsSupport;
        if (projectConf.getMessageFormat().equals("icu")) {
            argsSupport = new IcuMessageFormatSupport();
        } else if (projectConf.getMessageFormat().equals("classic")) {
            argsSupport = new DefaultMessageFormatSupport();
        } else {
            throw new RuntimeException(String.format("Unknown message formatter: %s", projectConf.getMessageFormat()));
        }
        return argsSupport;
    }

    public static class ArgInsert {
        private final String label;
        private final String reference;

        public ArgInsert(String label, String reference) {
            this.label = label;
            this.reference = reference;
        }

        public String getLabel() {
            return this.label;
        }

        public String getReference() {
            return this.reference;
        }
    }

    public static interface TypeChecker {
        public boolean isCompatibleWith(String var1, Set<String> var2);
    }
}

