/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.messageformat;

import de.codecamp.messages.MessageKeyWithArgs;
import de.codecamp.messages.shared.messageformat.MessageFormatSupport;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultMessageFormatSupport
implements MessageFormatSupport {
    public static final String ID = "default";
    private static final Set<String> NUMBER_FORMAT_TYPE_NAME_MAPPING = new HashSet<String>();
    private static final Set<String> DATE_FORMAT_TYPE_NAME_MAPPING;

    @Override
    public boolean supportsFormat(String messageFormat) {
        return ID.equals(messageFormat);
    }

    @Override
    public boolean hasArgNameSupport() {
        return false;
    }

    @Override
    public List<MessageFormatSupport.ArgInsert> getArgInsertOptions(MessageKeyWithArgs key) {
        ArrayList<MessageFormatSupport.ArgInsert> result = new ArrayList<MessageFormatSupport.ArgInsert>();
        String[] argTypes = key.getArgTypes();
        String[] argNames = key.getArgNames();
        for (int i = 0; i < argTypes.length; ++i) {
            String label = argNames[i] != null ? argNames[i] : Integer.toString(i + 1);
            label = label + " : " + this.formatArgType(argTypes[i]);
            String reference = "{" + i + "}";
            result.add(new MessageFormatSupport.ArgInsert(label, reference));
        }
        return result;
    }

    @Override
    public String createMessageBundleComment(MessageKeyWithArgs key) {
        String comment;
        if (key.hasArgs()) {
            String[] argTypes = key.getArgTypes();
            String[] argNames = key.getArgNames();
            StringBuilder messageArgComment = new StringBuilder();
            messageArgComment.append("Arguments: ");
            boolean first = true;
            for (int i = 0; i < argTypes.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    messageArgComment.append(" | ");
                }
                if (argNames[i] != null) {
                    messageArgComment.append(argNames[i]).append(":");
                }
                messageArgComment.append(this.formatArgType(argTypes[i]));
                messageArgComment.append(" -> ");
                messageArgComment.append("{").append(i).append("}");
            }
            comment = messageArgComment.toString();
        } else {
            comment = null;
        }
        return comment;
    }

    @Override
    public List<String> checkMessage(String message, String[] argTypes, String[] argNames, MessageFormatSupport.TypeChecker argTypeChecker) {
        int argCount;
        ArrayList<String> errors = new ArrayList<String>();
        int usedArgCount = 0;
        if (argTypes != null && argTypes.length > 0) {
            ArrayDeque<String> messageParts = new ArrayDeque<String>();
            messageParts.addLast(message);
            while (!messageParts.isEmpty()) {
                MessageFormat messageFormat;
                String messagePart = (String)messageParts.removeFirst();
                try {
                    messageFormat = new MessageFormat(messagePart);
                }
                catch (IllegalArgumentException ex) {
                    errors.add(String.format("The message is not a valid pattern: %s", ex.getMessage()));
                    return errors;
                }
                Format[] argFormats = messageFormat.getFormatsByArgumentIndex();
                if (argFormats.length > usedArgCount) {
                    usedArgCount = argFormats.length;
                }
                for (int argIndex = 0; argIndex < argFormats.length; ++argIndex) {
                    Format argFormat = argFormats[argIndex];
                    if (argFormat == null || argIndex >= argTypes.length) continue;
                    if (argFormat instanceof ChoiceFormat) {
                        for (Object f : ((ChoiceFormat)argFormat).getFormats()) {
                            messageParts.addLast((String)f);
                        }
                    }
                    String argTypeName = argTypes[argIndex];
                    if (argFormat instanceof NumberFormat) {
                        if (argTypeChecker.isCompatibleWith(argTypeName, NUMBER_FORMAT_TYPE_NAME_MAPPING)) continue;
                        errors.add(String.format("The message expects a number at index %d instead of the declared type: %s", argIndex, argTypeName));
                        continue;
                    }
                    if (!(argFormat instanceof DateFormat) || argTypeChecker.isCompatibleWith(argTypeName, DATE_FORMAT_TYPE_NAME_MAPPING)) continue;
                    errors.add(String.format("The message expects a date at index %d instead of the declared type: %s", argIndex, argTypeName));
                }
            }
        }
        int n = argCount = argTypes == null ? 0 : argTypes.length;
        if (usedArgCount > argCount) {
            errors.add(String.format("The message uses more arguments (%d) than are declared (%d)", usedArgCount, argCount));
        }
        return errors;
    }

    static {
        NUMBER_FORMAT_TYPE_NAME_MAPPING.addAll(Arrays.asList(Number.class.getName()));
        DATE_FORMAT_TYPE_NAME_MAPPING = new HashSet<String>();
        DATE_FORMAT_TYPE_NAME_MAPPING.addAll(Arrays.asList(Date.class.getName(), Calendar.class.getName(), Number.class.getName(), LocalDate.class.getName(), LocalTime.class.getName(), LocalDateTime.class.getName(), ZonedDateTime.class.getName(), OffsetTime.class.getName(), OffsetDateTime.class.getName(), Instant.class.getName()));
    }
}

