/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.messageformat;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.MessagePatternUtil;
import com.ibm.icu.util.CurrencyAmount;
import de.codecamp.messages.MessageKeyWithArgs;
import de.codecamp.messages.shared.messageformat.MessageFormatSupport;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class IcuMessageFormatSupport
implements MessageFormatSupport {
    public static final String ID = "icu";
    private static final SetMultimap<String, String> TYPE_NAME_MAPPING = HashMultimap.create();

    @Override
    public boolean supportsFormat(String messageFormat) {
        return ID.equals(messageFormat) || "classic".equals(messageFormat);
    }

    @Override
    public boolean hasArgNameSupport() {
        return true;
    }

    @Override
    public String formatArgType(String argType) {
        if ("javax.money.MonetaryAmount".equals(argType)) {
            return "currency";
        }
        return MessageFormatSupport.super.formatArgType(argType);
    }

    @Override
    public List<MessageFormatSupport.ArgInsert> getArgInsertOptions(MessageKeyWithArgs key) {
        ArrayList<MessageFormatSupport.ArgInsert> result = new ArrayList<MessageFormatSupport.ArgInsert>();
        String[] argTypes = key.getArgTypes();
        String[] argNames = key.getArgNames();
        for (int i = 0; i < argTypes.length; ++i) {
            String label = argNames[i] != null ? argNames[i] : Integer.toString(i + 1);
            label = label + " : " + this.formatArgType(argTypes[i]);
            String reference = argNames[i] != null ? "{" + argNames[i] + "}" : "{" + i + "}";
            result.add(new MessageFormatSupport.ArgInsert(label, reference));
        }
        return result;
    }

    @Override
    public String createMessageBundleComment(MessageKeyWithArgs key) {
        String comment;
        if (key.hasArgs()) {
            String[] argTypes = key.getArgTypes();
            String[] argNames = key.getArgNames();
            StringBuilder messageArgComment = new StringBuilder();
            messageArgComment.append("Arguments: ");
            boolean first = true;
            for (int i = 0; i < argTypes.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    messageArgComment.append(" | ");
                }
                if (argNames[i] != null) {
                    messageArgComment.append(argNames[i]).append(":");
                }
                messageArgComment.append(this.formatArgType(argTypes[i]));
                messageArgComment.append(" -> ");
                messageArgComment.append("{").append(i).append("}");
                if (argNames[i] == null) continue;
                messageArgComment.append("/{").append(argNames[i]).append("}");
            }
            comment = messageArgComment.toString();
        } else {
            comment = null;
        }
        return comment;
    }

    @Override
    public List<String> checkMessage(String message, String[] argTypes, String[] argNames, MessageFormatSupport.TypeChecker argTypeChecker) {
        MessageFormat mf;
        ArrayList<String> errors = new ArrayList<String>();
        try {
            mf = new MessageFormat(message);
        }
        catch (IllegalArgumentException ex) {
            errors.add(String.format("The message is not a valid ICU pattern: %s", ex.getMessage()));
            return errors;
        }
        if (mf.usesNamedArguments()) {
            Set availableArgNames = Stream.of(argNames).filter(Objects::nonNull).collect(Collectors.toSet());
            ArrayDeque<MessagePatternUtil.MessageNode> messageNodes = new ArrayDeque<MessagePatternUtil.MessageNode>();
            messageNodes.push(MessagePatternUtil.buildMessageNode((String)message));
            while (!messageNodes.isEmpty()) {
                MessagePatternUtil.MessageNode messageNode = (MessagePatternUtil.MessageNode)messageNodes.pop();
                for (MessagePatternUtil.MessageContentsNode node : messageNode.getContents()) {
                    String messageArgName;
                    if (node.getType() != MessagePatternUtil.MessageContentsNode.Type.ARG) continue;
                    MessagePatternUtil.ArgNode argNode = (MessagePatternUtil.ArgNode)node;
                    if (argNode.getNumber() > -1) {
                        errors.add("The message mixes named and indexed arguments.");
                        continue;
                    }
                    MessagePatternUtil.ComplexArgStyleNode complexStyle = argNode.getComplexStyle();
                    if (complexStyle != null) {
                        for (MessagePatternUtil.VariantNode variantNode : complexStyle.getVariants()) {
                            messageNodes.push(variantNode.getMessage());
                        }
                    }
                    if (!availableArgNames.contains(messageArgName = argNode.getName())) {
                        errors.add(String.format("The message uses an unavailable argument: %s", argNode.getName()));
                        continue;
                    }
                    String typeName = argNode.getTypeName();
                    if (typeName == null) continue;
                    String argType = null;
                    for (int i = 0; i < argNames.length; ++i) {
                        if (!messageArgName.equals(argNames[i])) continue;
                        argType = argTypes[i];
                    }
                    if (argType == null) continue;
                    this.checkTypeName(typeName, argType, argTypeChecker, errors);
                }
            }
        } else {
            int argCount;
            int maxIndex = -1;
            ArrayDeque<MessagePatternUtil.MessageNode> messageNodes = new ArrayDeque<MessagePatternUtil.MessageNode>();
            messageNodes.push(MessagePatternUtil.buildMessageNode((String)message));
            while (!messageNodes.isEmpty()) {
                MessagePatternUtil.MessageNode messageNode = (MessagePatternUtil.MessageNode)messageNodes.pop();
                for (MessagePatternUtil.MessageContentsNode node : messageNode.getContents()) {
                    String typeName;
                    if (node.getType() != MessagePatternUtil.MessageContentsNode.Type.ARG) continue;
                    MessagePatternUtil.ArgNode argNode = (MessagePatternUtil.ArgNode)node;
                    MessagePatternUtil.ComplexArgStyleNode complexStyle = argNode.getComplexStyle();
                    if (complexStyle != null) {
                        for (MessagePatternUtil.VariantNode variantNode : complexStyle.getVariants()) {
                            messageNodes.push(variantNode.getMessage());
                        }
                    }
                    if (argNode.getNumber() > maxIndex) {
                        maxIndex = argNode.getNumber();
                    }
                    if ((typeName = argNode.getTypeName()) == null) continue;
                    String argType = null;
                    if (argTypes.length > argNode.getNumber()) {
                        argType = argTypes[argNode.getNumber()];
                    }
                    this.checkTypeName(typeName, argType, argTypeChecker, errors);
                }
            }
            int usedArgCount = maxIndex + 1;
            int n = argCount = argTypes == null ? 0 : argTypes.length;
            if (usedArgCount > argCount) {
                errors.add(String.format("The message uses more arguments (%d) than are declared (%d)", usedArgCount, argCount));
            }
        }
        return errors;
    }

    private void checkTypeName(String typeName, String argType, MessageFormatSupport.TypeChecker argTypeChecker, List<String> errors) {
        Set expectedArgTypes = TYPE_NAME_MAPPING.get((Object)typeName);
        if (!argTypeChecker.isCompatibleWith(argType, expectedArgTypes)) {
            errors.add(String.format("The message format type %s does not match the expected argument types: %s", typeName, StringUtils.join((Iterable)expectedArgTypes, (String)",")));
        }
    }

    static {
        TYPE_NAME_MAPPING.putAll((Object)"number", Arrays.asList(Number.class.getName(), CurrencyAmount.class.getName(), "javax.money.MonetaryAmount"));
        TYPE_NAME_MAPPING.putAll((Object)"date", Arrays.asList(Date.class.getName(), com.ibm.icu.util.Calendar.class.getName(), Number.class.getName(), Calendar.class.getName(), LocalDate.class.getName(), LocalTime.class.getName(), LocalDateTime.class.getName(), ZonedDateTime.class.getName(), OffsetTime.class.getName(), OffsetDateTime.class.getName(), Instant.class.getName()));
        TYPE_NAME_MAPPING.putAll((Object)"time", (Iterable)TYPE_NAME_MAPPING.get((Object)"date"));
        TYPE_NAME_MAPPING.putAll((Object)"spellout", Arrays.asList(Number.class.getName()));
        TYPE_NAME_MAPPING.putAll((Object)"ordinal", Arrays.asList(Number.class.getName()));
        TYPE_NAME_MAPPING.putAll((Object)"duration", Arrays.asList(Number.class.getName()));
        TYPE_NAME_MAPPING.putAll((Object)"plural", Arrays.asList(Number.class.getName()));
        TYPE_NAME_MAPPING.putAll((Object)"select", Arrays.asList(String.class.getName()));
        TYPE_NAME_MAPPING.putAll((Object)"choice", Arrays.asList(Number.class.getName()));
    }
}

