/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.bundle;

import de.codecamp.messages.shared.bundle.BundleException;
import de.codecamp.messages.shared.bundle.FileSystemAdapter;
import de.codecamp.messages.shared.bundle.MessageBundleManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.lang3.StringUtils;

public class BundleFile<F>
implements Comparable<BundleFile<F>> {
    private final FileSystemAdapter<?, F> fileSystem;
    private final F file;
    private final String bundleName;
    private final Locale locale;
    private final String displayPath;
    private boolean readOnly = false;
    private final PropertiesConfiguration properties;
    private final FileHandler fileHandler;
    private boolean loaded = false;
    private boolean needsSaving;
    private Map<String, Integer> lineNumbersCache;

    public BundleFile(FileSystemAdapter<?, F> fileSystem, F file, Charset encoding, MessageBundleManager.BundleFileCoordinates coordinates, String displayPath) {
        this.bundleName = coordinates.getBundleName();
        this.locale = coordinates.getLocale();
        this.fileSystem = fileSystem;
        this.file = file;
        this.displayPath = displayPath;
        this.properties = new PropertiesConfiguration();
        boolean escapeUnicode = !encoding.contains(StandardCharsets.UTF_8);
        this.properties.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory(escapeUnicode));
        this.properties.setLayout((PropertiesConfigurationLayout)new SortedPropertiesConfigurationLayout());
        this.properties.getLayout().setLineSeparator("\n");
        this.properties.getLayout().setForceSingleLine(true);
        this.properties.getLayout().setGlobalSeparator(" = ");
        this.fileHandler = new FileHandler((FileBased)this.properties);
        this.fileHandler.setEncoding(encoding.name());
    }

    public F getLocation() {
        return this.file;
    }

    public String getDisplayPath() {
        return this.displayPath;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    boolean isLoaded() {
        return this.loaded;
    }

    public boolean isEmpty() {
        this.checkLoaded();
        return this.properties.isEmpty();
    }

    public Set<String> getKeys() {
        this.checkLoaded();
        return new HashSet<String>(this.properties.getLayout().getKeys());
    }

    public boolean hasMessageKey(String messageKey) {
        this.checkLoaded();
        return this.properties.containsKey(messageKey);
    }

    public boolean isMessageEmpty(String messageKey) {
        return !this.hasMessage(messageKey);
    }

    public boolean hasMessage(String messageKey) {
        return StringUtils.isNotEmpty((CharSequence)this.getMessage(messageKey));
    }

    public String getMessage(String messageKey) {
        this.checkLoaded();
        return this.properties.getString(messageKey);
    }

    public void setMessage(String messageKey, String message) {
        this.checkLoaded();
        this.checkReadOnly();
        Object oldMessage = this.properties.getProperty(messageKey);
        this.properties.setProperty(messageKey, (Object)message);
        if (!Objects.equals(oldMessage, message)) {
            this.needsSaving = true;
            this.lineNumbersCache = null;
        }
    }

    public String removeMessage(String messageKey) {
        this.checkLoaded();
        this.checkReadOnly();
        String message = null;
        if (this.properties.containsKey(messageKey)) {
            message = this.properties.getString(messageKey);
            this.properties.clearProperty(messageKey);
            this.needsSaving = true;
            this.lineNumbersCache = null;
        }
        return message;
    }

    public String getComment(String messageKey) {
        this.checkLoaded();
        return this.properties.getLayout().getComment(messageKey);
    }

    public void setComment(String messageKey, String comment) {
        this.checkLoaded();
        this.checkReadOnly();
        String oldComment = this.properties.getLayout().getComment(messageKey);
        this.properties.getLayout().setComment(messageKey, comment);
        if (!Objects.equals(oldComment, comment)) {
            this.needsSaving = true;
            this.lineNumbersCache = null;
        }
    }

    public Integer findLineNumberOfKey(String messageKey) {
        this.updateLineNumberOfKeys();
        return this.lineNumbersCache.get(messageKey);
    }

    public Map<String, Integer> findLineNumberOfKeys(Collection<String> messageKeys) {
        this.updateLineNumberOfKeys();
        HashMap<String, Integer> lineNumbers = new HashMap<String, Integer>();
        for (String messageKey : messageKeys) {
            Integer lineNumber = this.lineNumbersCache.get(messageKey);
            if (lineNumber == null) continue;
            lineNumbers.put(messageKey, lineNumber);
        }
        return lineNumbers;
    }

    private void updateLineNumberOfKeys() {
        this.checkLoaded();
        if (this.needsSaving()) {
            throw new IllegalStateException("Save file before querying line numbers.");
        }
        if (this.lineNumbersCache != null) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStream in = this.fileSystem.newInputStream(this.getLocation());
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.fileHandler.getEncoding()));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Exception ex) {
            String msg = "Failed to load message bundle file '%s'.";
            msg = String.format(msg, this.getDisplayPath());
            throw new BundleException(msg, ex);
        }
        Pattern pattern = Pattern.compile("^\\s*(([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)\\s*=.*");
        HashMap<String, Integer> lineNumbers = new HashMap<String, Integer>();
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            lineNumbers.put(matcher.group(1), i + 1);
        }
        this.lineNumbersCache = lineNumbers;
    }

    public boolean exists() {
        return this.fileSystem.exists(this.getLocation());
    }

    public boolean needsSaving() {
        return this.loaded && this.needsSaving;
    }

    public boolean needsSorting() {
        ArrayList<String> keysOriginal;
        ArrayList keysSorted = new ArrayList(this.properties.getLayout().getKeys());
        return !keysSorted.equals(keysOriginal = new ArrayList<String>(((SortedPropertiesConfigurationLayout)this.properties.getLayout()).getUnsortedKeys()));
    }

    public boolean save() {
        return this.save(false);
    }

    public boolean save(boolean force) {
        boolean msg2;
        block11: {
            if (this.isReadOnly() || !force && !this.needsSaving()) {
                return false;
            }
            this.checkReadOnly();
            try {
                this.fileSystem.createParentDirectories(this.getLocation());
            }
            catch (Exception ex) {
                String msg2 = "Failed to create directories for '%s'.";
                msg2 = String.format(msg2, this.getLocation());
                throw new BundleException(msg2, ex);
            }
            OutputStream out = this.fileSystem.newOutputStream(this.getLocation());
            try {
                this.fileHandler.save(out);
                this.needsSaving = false;
                msg2 = true;
                if (out == null) break block11;
            }
            catch (Throwable msg2) {
                try {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            msg2.addSuppressed(throwable);
                        }
                    }
                    throw msg2;
                }
                catch (Exception ex) {
                    String msg3 = "Failed to save message bundle file '%s'.";
                    msg3 = String.format(msg3, this.getDisplayPath());
                    throw new BundleException(msg3, ex);
                }
            }
            out.close();
        }
        return msg2;
    }

    private void checkLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException("Bundle file has not been loaded.");
        }
    }

    protected void ensureLoaded() {
        if (this.loaded) {
            return;
        }
        if (!this.exists()) {
            this.loaded = true;
            this.needsSaving = true;
            return;
        }
        try (InputStream in = this.fileSystem.newInputStream(this.getLocation());){
            this.fileHandler.load(in);
        }
        catch (Exception ex) {
            String msg = "Failed to load message bundle file '%s'.";
            msg = String.format(msg, this.getDisplayPath());
            throw new BundleException(msg, ex);
        }
        this.loaded = true;
        this.needsSaving = false;
    }

    public void delete() {
        this.checkReadOnly();
        try {
            this.fileSystem.deleteIfExists(this.getLocation());
        }
        catch (Exception ex) {
            String msg = "Failed to delete empty message bundle file '%s'.";
            msg = String.format(msg, this.getDisplayPath());
            throw new BundleException(msg, ex);
        }
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException(String.format("Message bundle '%s' is read-only.", this.bundleName));
        }
    }

    @Override
    public int compareTo(BundleFile<F> o) {
        int result = this.getBundleName().compareTo(o.getBundleName());
        if (result != 0) {
            return result;
        }
        return this.getLocale().toLanguageTag().compareTo(o.getLocale().toLanguageTag());
    }

    static class SortedPropertiesConfigurationLayout
    extends PropertiesConfigurationLayout {
        SortedPropertiesConfigurationLayout() {
        }

        public Set<String> getKeys() {
            return new TreeSet<String>(super.getKeys());
        }

        public Set<String> getUnsortedKeys() {
            return super.getKeys();
        }
    }
}

