/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.bundle;

import de.codecamp.messages.shared.bundle.FileSystemAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NioFileSystemAdapter
implements FileSystemAdapter<Path, Path> {
    @Override
    public Path getDirectory(String directoryPath) {
        return Paths.get(directoryPath, new String[0]);
    }

    @Override
    public List<Path> listFiles(Path dir, boolean recursive) throws IOException {
        List<Path> list;
        block8: {
            Stream<Path> pathStream = recursive ? Files.walk(dir, new FileVisitOption[0]) : Files.list(dir);
            try {
                list = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException | NotDirectoryException ex) {
                    return Collections.emptyList();
                }
            }
            pathStream.close();
        }
        return list;
    }

    @Override
    public Path getFile(Path dir, String fileName) {
        return dir.resolve(fileName);
    }

    @Override
    public String getFileName(Path file) {
        return file.getFileName().toString();
    }

    @Override
    public String getRelativeFilePath(Path dir, Path file) {
        return dir.relativize(file).toString();
    }

    @Override
    public String getDisplayPath(Path dir, Path file) {
        return dir.relativize(file).toString();
    }

    @Override
    public boolean exists(Path file) {
        return Files.exists(file, new LinkOption[0]);
    }

    @Override
    public void createParentDirectories(Path file) throws IOException {
        Path bundleDir = file.getParent();
        Files.createDirectories(bundleDir, new FileAttribute[0]);
    }

    @Override
    public void deleteIfExists(Path file) throws IOException {
        Files.deleteIfExists(file);
    }

    @Override
    public InputStream newInputStream(Path file) throws IOException {
        return Files.newInputStream(file, new OpenOption[0]);
    }

    @Override
    public OutputStream newOutputStream(Path file) throws IOException {
        return Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

