/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.model;

import de.codecamp.messages.MessageKeyWithArgs;
import java.lang.annotation.ElementType;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class MessageKeyWithSourceLocation
implements MessageKeyWithArgs,
Comparable<MessageKeyWithSourceLocation> {
    private static final String[] EMPTY_ARG_ARRAY = new String[0];
    private final String code;
    private final String[] argTypes;
    private final String[] argNames;
    private final String sourceType;
    private final String localPart;
    private final ElementType sourceElementType;
    private final String sourceElementName;
    private final boolean defaultMessageAvailable;

    public MessageKeyWithSourceLocation(String code, String[] argTypes, String[] argNames, String sourceType, String localPart, ElementType sourceElementType, String sourceElementName, boolean defaultMessageAvailable) {
        Objects.requireNonNull(code, "code must not be null");
        Objects.requireNonNull(sourceType, "sourceType must not be null");
        Objects.requireNonNull(localPart, "localPart must not be null");
        Objects.requireNonNull(sourceElementType, "sourceElementType must not be null");
        Objects.requireNonNull(sourceElementName, "sourceElementName must not be null");
        this.code = code;
        this.argTypes = argTypes == null ? null : (String[])argTypes.clone();
        this.argNames = argNames == null ? null : (String[])argNames.clone();
        this.sourceType = sourceType;
        this.localPart = localPart;
        this.sourceElementType = sourceElementType;
        this.sourceElementName = sourceElementName;
        this.defaultMessageAvailable = defaultMessageAvailable;
    }

    public String getCode() {
        return this.code;
    }

    public boolean hasArgs() {
        return ArrayUtils.isNotEmpty((Object[])this.argTypes);
    }

    public String[] getArgTypes() {
        if (this.argTypes == null) {
            return EMPTY_ARG_ARRAY;
        }
        return (String[])this.argTypes.clone();
    }

    public String[] getArgNames() {
        if (this.argNames == null) {
            return EMPTY_ARG_ARRAY;
        }
        return (String[])this.argNames.clone();
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public ElementType getSourceElementType() {
        return this.sourceElementType;
    }

    public String getSourceElementName() {
        return this.sourceElementName;
    }

    public boolean isDefaultMessageAvailable() {
        return this.defaultMessageAvailable;
    }

    @Override
    public int compareTo(MessageKeyWithSourceLocation o) {
        return this.getCode().compareTo(o.getCode());
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MessageKeyWithSourceLocation)) {
            return false;
        }
        MessageKeyWithSourceLocation other = (MessageKeyWithSourceLocation)obj;
        return this.getCode().equals(other.getCode());
    }
}

