/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.validation;

import de.codecamp.messages.shared.model.MessageModule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class MessageValidationUtils {
    private MessageValidationUtils() {
    }

    public static Set<Locale> getRequiredLocales(Collection<Locale> locales) {
        LinkedHashSet<Locale> requiredLocales = new LinkedHashSet<Locale>();
        for (String language : MessageValidationUtils.getLanguages(locales)) {
            Locale languageOnlyLocale = MessageValidationUtils.getLanguageOnlyLocale(locales, language);
            if (languageOnlyLocale != null) {
                requiredLocales.add(languageOnlyLocale);
                continue;
            }
            requiredLocales.addAll(MessageValidationUtils.getLocalesForLanguage(locales, language));
        }
        return requiredLocales;
    }

    private static Set<String> getLanguages(Collection<Locale> locales) {
        return locales.stream().map(Locale::getLanguage).collect(Collectors.toSet());
    }

    private static Set<Locale> getLocalesForLanguage(Collection<Locale> locales, String language) {
        return locales.stream().filter(locale -> locale.getLanguage().equals(language)).collect(Collectors.toSet());
    }

    private static Locale getLanguageOnlyLocale(Collection<Locale> locales, String language) {
        return locales.stream().filter(locale -> locale.getLanguage().equals(language) && locale.getCountry().isEmpty()).findAny().orElse(null);
    }

    public static Set<Locale> getRequiredLocales(String messageKeyCode, MessageModule index, Map<String, ? extends MessageModule> importedIndexes, BiPredicate<MessageModule, String> keyChecker) {
        Set<Locale> requiredLocales = MessageValidationUtils.getRequiredLocales(MessageValidationUtils.getTargetLocales(messageKeyCode, false, index, importedIndexes, keyChecker));
        requiredLocales.removeAll(MessageValidationUtils.getTargetLocales(messageKeyCode, true, index, importedIndexes, keyChecker));
        return requiredLocales;
    }

    public static Set<Locale> getTargetLocales(String messageKeyCode, boolean importsOnly, MessageModule index, Map<String, ? extends MessageModule> importedIndexes, BiPredicate<MessageModule, String> keyChecker) {
        ArrayDeque stack = new ArrayDeque();
        if (importsOnly) {
            for (String importedModule : index.getImportedModules()) {
                MessageModule importedIndex = importedIndexes.get(importedModule);
                if (importedIndex == null) {
                    throw new RuntimeException("Imported module not found: " + importedModule);
                }
                stack.push(new ArrayList<MessageModule>(Arrays.asList(importedIndex)));
            }
        } else {
            stack.push(new ArrayList<MessageModule>(Arrays.asList(index)));
        }
        HashSet<Locale> result = new HashSet<Locale>();
        while (!stack.isEmpty()) {
            List chain = (List)stack.pop();
            MessageModule i = (MessageModule)chain.get(chain.size() - 1);
            if (keyChecker.test(i, messageKeyCode)) {
                chain.stream().flatMap(in -> in.getTargetLocales().stream()).forEach(result::add);
                continue;
            }
            for (String importedModule : i.getImportedModules()) {
                MessageModule importedIndex = importedIndexes.get(importedModule);
                if (importedIndex == null) continue;
                ArrayList<MessageModule> newChain = new ArrayList<MessageModule>(chain);
                newChain.add(importedIndex);
                stack.push(newChain);
            }
        }
        return result;
    }
}

