/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.conf;

import de.codecamp.messages.shared.bundle.MessageBundleManager;
import de.codecamp.messages.shared.bundle.NioFileSystemAdapter;
import de.codecamp.messages.shared.conf.BundleMapping;
import de.codecamp.messages.shared.conf.BundleMismatchPolicy;
import de.codecamp.messages.shared.conf.ConfValueProvider;
import de.codecamp.messages.shared.conf.MessageArgPolicy;
import de.codecamp.messages.shared.conf.MissingMessagePolicy;
import de.codecamp.messages.shared.conf.Mode;
import de.codecamp.messages.shared.conf.ProjectConfException;
import de.codecamp.messages.shared.conf.UndeclaredKeyPolicy;
import de.codecamp.messages.shared.model.MessageModule;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class ProjectConf
implements MessageModule {
    public static final String ERROR_CONF_FILE_ERROR = "ProjectConfFileError";
    public static final String ERROR_MISSING_OPTION = "MissingOption";
    public static final String ERROR_ILLEGAL_LOCALE = "IllegalLocale";
    public static final String ERROR_ILLEGAL_BUNDLE_MAPPING = "IllegalBundleMapping";
    public static final String ERROR_ILLEGAL_TYPE_ABBREVIATION = "IllegalTypeAbbreviation";
    public static final String ERROR_ILLEGAL_IMPORT = "IllegalImport";
    public static final String ERROR_MISSING_IMPORT = "MissingImport";
    public static final String ERROR_UNKNOWN_VALUE = "UnknownValue";
    public static final String PROJECT_CONF_FILE_NAME = "messages-conf.properties";
    public static final String CONF_PREFIX = "messages.";
    public static final String CONF_PROJECT_DIR = "messages.projectDir";
    public static final String CONF_MODULE_NAME = "messages.moduleName";
    public static final String CONF_BUNDLE_DIR = "messages.bundleDir";
    public static final String BUNDLE_DIR_DEFAULT = "src/main/resources/messages";
    public static final String CONF_BUNDLE_ENCODING = "messages.bundleEncoding";
    public static final String CONF_BUNDLES = "messages.bundles";
    public static final String BUNDLES_DEFAULT = ":messages";
    public static final String BUNDLES_IMPORTS = "$imports";
    public static final String CONF_IGNORED_BUNDLES = "messages.ignoredBundles";
    public static final String CONF_TARGET_LOCALES = "messages.targetLocales";
    public static final String CONF_IMPORTS = "messages.imports";
    public static final String CONF_TYPE_ABBREVIATIONS = "messages.typeAbbreviations";
    public static final String CONF_MODE = "messages.mode";
    public static final String CONF_MISSING_MESSAGE_POLICY = "messages.missingMessagePolicy";
    public static final String CONF_MESSAGE_ARG_POLICY = "messages.messageArgPolicy";
    public static final String CONF_UNDECLARED_KEY_POLICY = "messages.undeclaredKeyPolicy";
    public static final String CONF_UNDECLARED_KEY_COMMENT = "messages.undeclaredKeyComment";
    public static final String UNDECLARED_KEY_COMMENT_DEFAULT = "FIXME undeclared message key";
    public static final String CONF_BUNDLE_MISMATCH_POLICY = "messages.bundleMismatchPolicy";
    public static final String CONF_MESSAGE_FORMAT = "messages.messageFormat";
    public static final String CONF_GENERATE_CONSTANTS = "messages.generateConstants";
    public static final String CONF_GENERATE_PROXIES = "messages.generateProxies";
    public static final List<String> ALL_CONF_NAMES = List.of("messages.moduleName", "messages.projectDir", "messages.bundleDir", "messages.bundleEncoding", "messages.bundles", "messages.ignoredBundles", "messages.targetLocales", "messages.imports", "messages.mode", "messages.missingMessagePolicy", "messages.messageArgPolicy", "messages.undeclaredKeyPolicy", "messages.undeclaredKeyComment", "messages.bundleMismatchPolicy", "messages.messageFormat", "messages.generateConstants", "messages.generateProxies");
    private final String moduleName;
    private final String projectDir;
    private final String bundleDir;
    private final Charset bundleEncoding;
    private final Set<String> ignoredBundles;
    private final List<BundleMapping> bundleMappings;
    private final List<Locale> targetLocales;
    private final List<String> imports;
    private final Map<String, String> typeAbbreviations;
    private final Mode mode;
    private final MissingMessagePolicy missingMessagePolicy;
    private final MessageArgPolicy messageArgPolicy;
    private final UndeclaredKeyPolicy undeclaredKeyPolicy;
    private final String undeclaredKeyComment;
    private final BundleMismatchPolicy bundleMismatchPolicy;
    private final String messageFormat;
    private final boolean generateConstants;
    private final boolean generateProxies;
    private List<BundleMapping> resolvedBundleMappings;

    public ProjectConf(ConfValueProvider confProvider) throws ProjectConfException {
        Path messagesPropsPath;
        this.projectDir = ProjectConf.parseString(confProvider.getConf(CONF_PROJECT_DIR), true, null);
        ConfValueProvider extConfProvider = null;
        if (this.projectDir != null && Files.isRegularFile(messagesPropsPath = Paths.get(this.projectDir, PROJECT_CONF_FILE_NAME), new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(messagesPropsPath, new OpenOption[0]);){
                Properties messagesProperties = new Properties();
                messagesProperties.load(in);
                extConfProvider = name -> {
                    String value = confProvider.getConf(name);
                    if (value == null) {
                        value = messagesProperties.getProperty(name);
                    }
                    if (value == null) {
                        value = messagesProperties.getProperty(StringUtils.removeStart((String)name, (String)CONF_PREFIX));
                    }
                    return value;
                };
            }
            catch (IOException ex) {
                String msg = "Failed to read %s in project directory '%s'.";
                msg = String.format(msg, PROJECT_CONF_FILE_NAME, this.projectDir);
                throw new ProjectConfException(msg, (Throwable)ex, ERROR_CONF_FILE_ERROR, this.projectDir);
            }
        }
        if (extConfProvider == null) {
            extConfProvider = confProvider;
        }
        this.moduleName = ProjectConf.parseString(extConfProvider.getConf(CONF_MODULE_NAME), true, "application");
        this.bundleEncoding = ProjectConf.parseBundleEncoding(extConfProvider.getConf(CONF_BUNDLE_ENCODING));
        this.ignoredBundles = ProjectConf.parseIgnoredBundles(extConfProvider.getConf(CONF_IGNORED_BUNDLES));
        this.bundleMappings = ProjectConf.parseBundles(extConfProvider.getConf(CONF_BUNDLES), this.getModuleName());
        this.targetLocales = ProjectConf.parseLocales(extConfProvider.getConf(CONF_TARGET_LOCALES), new Locale[0]);
        this.imports = this.parseImports(extConfProvider.getConf(CONF_IMPORTS));
        this.typeAbbreviations = ProjectConf.parseTypeAbbreviations(extConfProvider.getConf(CONF_TYPE_ABBREVIATIONS));
        this.mode = this.parseEnum(extConfProvider.getConf(CONF_MODE), Mode.class, Mode.RELEASE);
        this.missingMessagePolicy = this.parseEnum(extConfProvider.getConf(CONF_MISSING_MESSAGE_POLICY), MissingMessagePolicy.class, this.mode.missingMessagePolicy());
        this.messageArgPolicy = this.parseEnum(extConfProvider.getConf(CONF_MESSAGE_ARG_POLICY), MessageArgPolicy.class, this.mode.messageArgPolicy());
        this.undeclaredKeyPolicy = this.parseEnum(extConfProvider.getConf(CONF_UNDECLARED_KEY_POLICY), UndeclaredKeyPolicy.class, this.mode.undeclaredKeyPolicy());
        this.undeclaredKeyComment = ProjectConf.parseString(extConfProvider.getConf(CONF_UNDECLARED_KEY_COMMENT), true, UNDECLARED_KEY_COMMENT_DEFAULT);
        this.bundleMismatchPolicy = this.parseEnum(extConfProvider.getConf(CONF_BUNDLE_MISMATCH_POLICY), BundleMismatchPolicy.class, this.mode.bundleMismatchPolicy());
        this.bundleDir = ProjectConf.parseString(extConfProvider.getConf(CONF_BUNDLE_DIR), true, BUNDLE_DIR_DEFAULT);
        this.messageFormat = ProjectConf.parseString(extConfProvider.getConf(CONF_MESSAGE_FORMAT), true, "icu");
        if (this.messageFormat != null && !this.messageFormat.equals("classic") && !this.messageFormat.equals("icu")) {
            String msg = "Unknown value '%s' for %s.";
            msg = String.format(msg, this.messageFormat, CONF_MESSAGE_FORMAT);
            throw new ProjectConfException(msg, ERROR_UNKNOWN_VALUE, this.messageFormat, CONF_MESSAGE_FORMAT);
        }
        this.generateConstants = this.parseBoolean(extConfProvider.getConf(CONF_GENERATE_CONSTANTS), true);
        this.generateProxies = this.parseBoolean(extConfProvider.getConf(CONF_GENERATE_PROXIES), false);
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public String getBundleDir() {
        if (this.projectDir != null) {
            return Paths.get(this.projectDir, this.bundleDir).toString();
        }
        return this.bundleDir;
    }

    public Charset getBundleEncoding() {
        return this.bundleEncoding;
    }

    public Set<String> getIgnoredBundles() {
        return this.ignoredBundles;
    }

    @Override
    public List<BundleMapping> getBundleMappings() {
        return this.bundleMappings;
    }

    @Override
    public List<Locale> getTargetLocales() {
        return this.targetLocales;
    }

    @Override
    public List<String> getImportedModules() {
        return this.getImports();
    }

    public List<String> getImports() {
        return this.imports;
    }

    public Map<String, String> getTypeAbbreviations() {
        return this.typeAbbreviations;
    }

    public Mode getMode() {
        return this.mode;
    }

    public MissingMessagePolicy getMissingMessagePolicy() {
        return this.missingMessagePolicy;
    }

    public MessageArgPolicy getMessageArgPolicy() {
        return this.messageArgPolicy;
    }

    public UndeclaredKeyPolicy getUndeclaredKeyPolicy() {
        return this.undeclaredKeyPolicy;
    }

    public String getUndeclaredKeyComment() {
        return this.undeclaredKeyComment;
    }

    public BundleMismatchPolicy getBundleMismatchPolicy() {
        return this.bundleMismatchPolicy;
    }

    @Override
    public String getMessageFormat() {
        return this.messageFormat;
    }

    public boolean getGenerateConstants() {
        return this.generateConstants;
    }

    public boolean getGenerateProxies() {
        return this.generateProxies;
    }

    private static String parseString(String rawValue, boolean blankToNull, String defaultValue) throws ProjectConfException {
        String value = rawValue;
        if (blankToNull) {
            value = (String)StringUtils.defaultIfBlank((CharSequence)value, null);
        }
        if ((value = StringUtils.trim((String)value)) == null) {
            value = defaultValue;
        }
        return value;
    }

    private static Charset parseBundleEncoding(String rawValue) throws ProjectConfException {
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            return StandardCharsets.UTF_8;
        }
        rawValue = StringUtils.trim((String)rawValue);
        try {
            return Charset.forName(rawValue);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
            throw (ProjectConfException)new ProjectConfException("Message bundle encoding '%s' not supported.", ERROR_UNKNOWN_VALUE, rawValue).initCause(ex);
        }
    }

    private static List<BundleMapping> parseBundles(String rawValue, String moduleName) throws ProjectConfException {
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            rawValue = BUNDLES_DEFAULT;
        }
        ArrayList<BundleMapping> bundleMappings = new ArrayList<BundleMapping>();
        for (String bundleToken : StringUtils.split((String)rawValue, (String)",")) {
            if ((bundleToken = bundleToken.trim()).equals(BUNDLES_IMPORTS)) {
                bundleMappings.add(BundleMapping.IMPORTS_PLACEHOLDER);
                continue;
            }
            if (!bundleToken.contains(":")) {
                String msg = "Illegal message bundle mapping: %s";
                msg = String.format(msg, bundleToken);
                throw new ProjectConfException(msg, ERROR_ILLEGAL_BUNDLE_MAPPING, bundleToken);
            }
            String[] tokens = StringUtils.splitPreserveAllTokens((String)bundleToken, (String)":", (int)2);
            String packageName = tokens[0].trim();
            String bundleName = tokens[1].trim();
            if (StringUtils.isNotBlank((CharSequence)moduleName)) {
                bundleName = (moduleName + "." + bundleName).replace('/', '.');
            }
            if (bundleToken.contains("_")) {
                String msg = "Underscore (_) now allowed within message bundle name. It's reserved for the locale: %s";
                msg = String.format(msg, bundleToken);
                throw new ProjectConfException(msg, ERROR_ILLEGAL_BUNDLE_MAPPING, bundleName);
            }
            bundleMappings.add(new BundleMapping(packageName, bundleName));
        }
        return List.copyOf(bundleMappings);
    }

    private static Set<String> parseIgnoredBundles(String rawValue) {
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            return Collections.emptySet();
        }
        Set ignoredBundles = Stream.of(StringUtils.split((String)rawValue, (String)",")).filter(StringUtils::isNotBlank).map(StringUtils::trim).collect(Collectors.toSet());
        return Set.copyOf(ignoredBundles);
    }

    private static List<Locale> parseLocales(String rawValue, Locale ... defaults) throws ProjectConfException {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (!StringUtils.isBlank((CharSequence)rawValue)) {
            List localeStrings = Stream.of(StringUtils.split((String)rawValue, (String)",")).filter(StringUtils::isNotBlank).map(StringUtils::trim).collect(Collectors.toList());
            for (String localeString : localeStrings) {
                Locale locale = Locale.forLanguageTag(localeString);
                if (locale.getLanguage().isEmpty() && localeString.contains("_")) {
                    locale = LocaleUtils.toLocale((String)localeString);
                }
                if (locale.getLanguage().isEmpty()) {
                    String msg = "The locale string '%s' did not contain a language.";
                    msg = String.format(msg, localeString);
                    throw new ProjectConfException(msg, ERROR_ILLEGAL_LOCALE, localeString);
                }
                locales.add(locale);
            }
        }
        if (locales.isEmpty()) {
            locales.addAll(Arrays.asList(defaults));
        }
        if (locales.isEmpty()) {
            String msg = "Option '%s' must be set.";
            msg = String.format(msg, CONF_TARGET_LOCALES);
            throw new ProjectConfException(msg, ERROR_MISSING_OPTION, CONF_TARGET_LOCALES);
        }
        return List.copyOf(locales);
    }

    private List<String> parseImports(String rawValue) throws ProjectConfException {
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            return Collections.emptyList();
        }
        List parsedImports = Stream.of(StringUtils.split((String)rawValue, (String)",")).filter(StringUtils::isNotBlank).map(StringUtils::trim).collect(Collectors.toList());
        return List.copyOf(parsedImports);
    }

    private static Map<String, String> parseTypeAbbreviations(String rawValue) throws ProjectConfException {
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> typeAbbreviations = new HashMap<String, String>();
        for (String abbreviationItem : StringUtils.split((String)rawValue, (String)",")) {
            if (!(abbreviationItem = abbreviationItem.trim()).contains(":")) {
                String msg = "Illegal type abbreviation: %s";
                msg = String.format(msg, abbreviationItem);
                throw new ProjectConfException(msg, ERROR_ILLEGAL_TYPE_ABBREVIATION, abbreviationItem);
            }
            String[] tokens = StringUtils.splitPreserveAllTokens((String)abbreviationItem, (String)":", (int)2);
            String abbreviation = tokens[0].trim();
            String fullyQualifiedType = tokens[1].trim();
            typeAbbreviations.put(abbreviation, fullyQualifiedType);
        }
        return Map.copyOf(typeAbbreviations);
    }

    private <T extends Enum<T>> T parseEnum(String rawValue, Class<T> enumType) throws ProjectConfException {
        if (StringUtils.isEmpty((CharSequence)rawValue)) {
            return null;
        }
        Enum enumValue = EnumUtils.getEnum(enumType, (String)rawValue);
        if (enumValue == null) {
            String msg = "Unknown value '%s' for %s.";
            msg = String.format(msg, rawValue, enumType.getSimpleName());
            throw new ProjectConfException(msg, ERROR_UNKNOWN_VALUE, rawValue, enumType.getSimpleName());
        }
        return (T)enumValue;
    }

    private <T extends Enum<T>> T parseEnum(String rawValue, Class<T> enumType, T defaultValue) throws ProjectConfException {
        T e = this.parseEnum(rawValue, enumType);
        if (e == null) {
            e = defaultValue;
        }
        return e;
    }

    private Boolean parseBoolean(String rawValue, Boolean defaultValue) {
        Boolean result = BooleanUtils.toBooleanObject((String)rawValue, (String)"true", (String)"false", null);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public void resolveBundleMappings(Function<String, MessageModule> importedModuleProvider) throws ProjectConfException {
        this.resolvedBundleMappings = ProjectConf.getImportedBundleMappings(this, importedModuleProvider);
    }

    private static List<BundleMapping> getImportedBundleMappings(MessageModule module, Function<String, MessageModule> importedModuleProvider) throws ProjectConfException {
        ArrayList<BundleMapping> bundleMappings;
        int placeholderIndex;
        ArrayList<BundleMapping> importedBundleMappings = new ArrayList<BundleMapping>();
        if (module.getImportedModules() != null) {
            for (String importedModuleName : module.getImportedModules()) {
                MessageModule importedModule = importedModuleProvider.apply(importedModuleName);
                if (importedModule == null) {
                    String msg = "Imported messages module '%s' not found.";
                    msg = String.format(msg, importedModuleName);
                    throw new ProjectConfException(msg, ERROR_MISSING_IMPORT, importedModuleName);
                }
                importedBundleMappings.addAll(ProjectConf.getImportedBundleMappings(importedModule, importedModuleProvider));
            }
        }
        if ((placeholderIndex = (bundleMappings = new ArrayList<BundleMapping>(module.getBundleMappings())).indexOf(BundleMapping.IMPORTS_PLACEHOLDER)) > -1) {
            bundleMappings.remove(placeholderIndex);
            bundleMappings.addAll(placeholderIndex, importedBundleMappings);
        } else {
            bundleMappings.addAll(importedBundleMappings);
        }
        return bundleMappings;
    }

    public Optional<String> toTargetBundleName(String messageKey) {
        return this.toTargetBundleName(messageKey, false);
    }

    public Optional<String> toTargetBundleName(String messageKey, boolean onlyLocalMappings) {
        if (!onlyLocalMappings && this.resolvedBundleMappings == null) {
            throw new IllegalStateException("Message bundle mappings have not been resolved.");
        }
        List<BundleMapping> mappings = onlyLocalMappings ? this.bundleMappings : this.resolvedBundleMappings;
        for (BundleMapping mapping : mappings) {
            Pattern messageKeyPattern = mapping.getMessageKeyPatternAsRegex();
            Matcher matcher = messageKeyPattern.matcher(messageKey);
            if (!matcher.matches()) continue;
            String bundleName = mapping.getBundleNamePattern();
            if (bundleName.contains("*") && matcher.groupCount() >= 1) {
                String subPackage = StringUtils.removeStart((String)matcher.group(1), (String)".");
                subPackage = StringUtils.substringBefore((String)subPackage, (String)".");
                bundleName = mapping.getBundleNamePattern().replace("*", subPackage);
            }
            return Optional.of(bundleName);
        }
        return Optional.empty();
    }

    public MessageBundleManager<Path, Path, IOException> createDefaultMessageBundleManager() {
        return new MessageBundleManager<Path, Path, IOException>(this, new NioFileSystemAdapter());
    }
}

