/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.messageformat;

import de.codecamp.messages.MessageKeyWithArgs;
import de.codecamp.messages.shared.conf.ProjectConf;
import de.codecamp.messages.shared.messageformat.AbstractMessageFormatSupport;
import de.codecamp.messages.shared.messageformat.DefaultMessageFormatSupport;
import de.codecamp.messages.shared.messageformat.IcuMessageFormatSupport;
import java.util.List;
import java.util.Set;

public interface MessageFormatSupport {
    public boolean supportsFormat(String var1);

    public boolean hasArgNameSupport();

    public String formatArgType(String var1);

    public List<ArgInsert> getArgInsertOptions(MessageKeyWithArgs var1);

    public String createMessageBundleComment(MessageKeyWithArgs var1);

    public List<String> checkMessage(String var1, String[] var2, String[] var3, TypeChecker var4);

    public static MessageFormatSupport getSupport(ProjectConf projectConf) {
        AbstractMessageFormatSupport argsSupport;
        if (projectConf.getMessageFormat().equals("icu")) {
            argsSupport = new IcuMessageFormatSupport();
        } else if (projectConf.getMessageFormat().equals("classic")) {
            argsSupport = new DefaultMessageFormatSupport();
        } else {
            throw new IllegalStateException(String.format("Unknown message formatter: %s", projectConf.getMessageFormat()));
        }
        return argsSupport;
    }

    public static interface TypeChecker {
        public boolean isCompatibleWith(String var1, Set<String> var2);
    }

    public static class ArgInsert {
        private final String label;
        private final String reference;

        public ArgInsert(String label, String reference) {
            this.label = label;
            this.reference = reference;
        }

        public String getLabel() {
            return this.label;
        }

        public String getReference() {
            return this.reference;
        }
    }
}

