/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.messageformat;

import de.codecamp.messages.shared.messageformat.MessageFormatSupport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMessageFormatSupport
implements MessageFormatSupport {
    public static final List<String> JAVATYPES_INTEGER = List.of(Byte.TYPE.getName(), Byte.class.getName(), Short.TYPE.getName(), Short.class.getName(), Integer.TYPE.getName(), Integer.class.getName(), Long.TYPE.getName(), Long.class.getName(), BigInteger.class.getName());
    public static final List<String> JAVATYPES_DECIMAL = List.of(Float.TYPE.getName(), Float.class.getName(), Double.TYPE.getName(), Double.class.getName(), BigDecimal.class.getName());
    public static final List<String> JAVATYPES_DATETIME = List.of(Date.class.getName(), Calendar.class.getName(), LocalDateTime.class.getName(), ZonedDateTime.class.getName(), OffsetDateTime.class.getName(), Instant.class.getName());
    public static final List<String> JAVATYPES_DATE = List.of(LocalDate.class.getName());
    public static final List<String> JAVATYPES_TIME = List.of(LocalTime.class.getName(), OffsetTime.class.getName());

    @Override
    public String formatArgType(String argType) {
        if (String.class.getName().equals(argType)) {
            return "text";
        }
        if (JAVATYPES_INTEGER.contains(argType)) {
            return "integer";
        }
        if (JAVATYPES_DECIMAL.contains(argType)) {
            return "decimal";
        }
        if (JAVATYPES_DATETIME.contains(argType)) {
            return "date/time";
        }
        if (JAVATYPES_DATE.contains(argType)) {
            return "date";
        }
        if (JAVATYPES_TIME.contains(argType)) {
            return "time";
        }
        return StringUtils.removeStart((String)argType, (String)"java.lang.");
    }
}

