/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.shared.messageformat;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.MessagePatternUtil;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.CurrencyAmount;
import de.codecamp.messages.MessageKeyWithArgs;
import de.codecamp.messages.shared.messageformat.AbstractMessageFormatSupport;
import de.codecamp.messages.shared.messageformat.MessageFormatSupport;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class IcuMessageFormatSupport
extends AbstractMessageFormatSupport {
    public static final String ID = "icu";
    private static final String ARGTYPE_NUMBER = "number";
    private static final String ARGTYPE_DATE = "date";
    private static final String ARGTYPE_TIME = "time";
    private static final List<String> JAVATYPES_CURRENCY = List.of(CurrencyAmount.class.getName(), "javax.money.MonetaryAmount");
    private static final SetMultimap<String, String> ARGTYPE_TO_JAVA_MAPPING = HashMultimap.create();
    private static final Map<String, String> JAVA_TO_ARGTYPE__MAPPING;

    @Override
    public boolean supportsFormat(String messageFormatId) {
        return ID.equals(messageFormatId) || "classic".equals(messageFormatId);
    }

    @Override
    public boolean hasArgNameSupport() {
        return true;
    }

    @Override
    public List<MessageFormatSupport.ArgInsert> getArgInsertOptions(MessageKeyWithArgs key) {
        ArrayList<MessageFormatSupport.ArgInsert> result = new ArrayList<MessageFormatSupport.ArgInsert>();
        String[] argTypes = key.getArgTypes();
        String[] argNames = key.getArgNames();
        for (int i = 0; i < argTypes.length; ++i) {
            String label = argNames[i] + " : " + this.formatArgType(argTypes[i]);
            String reference = IcuMessageFormatSupport.toMessageFormateArgument(argNames[i], argTypes[i]);
            result.add(new MessageFormatSupport.ArgInsert(label, reference));
        }
        return result;
    }

    @Override
    public String createMessageBundleComment(MessageKeyWithArgs key) {
        String comment;
        if (key.hasArgs()) {
            String[] argTypes = key.getArgTypes();
            String[] argNames = key.getArgNames();
            StringBuilder messageArgComment = new StringBuilder(50);
            messageArgComment.append("Arguments: ");
            boolean first = true;
            for (int i = 0; i < argTypes.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    messageArgComment.append(" | ");
                }
                messageArgComment.append(argNames[i]);
                messageArgComment.append(" (").append(this.formatArgType(argTypes[i])).append(")");
                messageArgComment.append(" -> ");
                messageArgComment.append(IcuMessageFormatSupport.toMessageFormateArgument(argNames[i], argTypes[i]));
            }
            comment = messageArgComment.toString();
        } else {
            comment = null;
        }
        return comment;
    }

    private static String toMessageFormateArgument(String argName, String javaArgType) {
        StringBuilder reference = new StringBuilder(20);
        reference.append("{");
        reference.append(argName);
        String mfArgType = JAVA_TO_ARGTYPE__MAPPING.get(javaArgType);
        if (mfArgType != null) {
            reference.append(",").append(mfArgType);
        }
        reference.append("}");
        return reference.toString();
    }

    @Override
    public String formatArgType(String argType) {
        if ("javax.money.MonetaryAmount".equals(argType) || CurrencyAmount.class.getName().equals(argType)) {
            return "currency";
        }
        return super.formatArgType(argType);
    }

    @Override
    public List<String> checkMessage(String message, String[] argTypes, String[] argNames, MessageFormatSupport.TypeChecker argTypeChecker) {
        MessageFormat mf;
        ArrayList<String> errors = new ArrayList<String>();
        try {
            mf = new MessageFormat(message);
        }
        catch (IllegalArgumentException ex) {
            errors.add(String.format("The message is not a valid ICU pattern: %s", ex.getMessage()));
            return errors;
        }
        if (mf.usesNamedArguments()) {
            Set availableArgNames = Stream.of(argNames).filter(Objects::nonNull).collect(Collectors.toSet());
            ArrayDeque<MessagePatternUtil.MessageNode> messageNodes = new ArrayDeque<MessagePatternUtil.MessageNode>();
            messageNodes.push(MessagePatternUtil.buildMessageNode((String)message));
            while (!messageNodes.isEmpty()) {
                MessagePatternUtil.MessageNode messageNode = (MessagePatternUtil.MessageNode)messageNodes.pop();
                for (MessagePatternUtil.MessageContentsNode node : messageNode.getContents()) {
                    String messageArgName;
                    if (node.getType() != MessagePatternUtil.MessageContentsNode.Type.ARG) continue;
                    MessagePatternUtil.ArgNode argNode = (MessagePatternUtil.ArgNode)node;
                    if (argNode.getNumber() > -1) {
                        errors.add("The message mixes named and indexed arguments.");
                        continue;
                    }
                    MessagePatternUtil.ComplexArgStyleNode complexStyle = argNode.getComplexStyle();
                    if (complexStyle != null) {
                        for (MessagePatternUtil.VariantNode variantNode : complexStyle.getVariants()) {
                            messageNodes.push(variantNode.getMessage());
                        }
                    }
                    if (!availableArgNames.contains(messageArgName = argNode.getName())) {
                        errors.add(String.format("The message uses an unavailable argument: %s", argNode.getName()));
                        continue;
                    }
                    String typeName = argNode.getTypeName();
                    if (typeName == null) continue;
                    String argType = null;
                    for (int i = 0; i < argNames.length; ++i) {
                        if (!messageArgName.equals(argNames[i])) continue;
                        argType = argTypes[i];
                    }
                    if (argType == null) continue;
                    IcuMessageFormatSupport.checkTypeName(typeName, argType, argTypeChecker, errors);
                }
            }
        } else {
            int argCount;
            int maxIndex = -1;
            ArrayDeque<MessagePatternUtil.MessageNode> messageNodes = new ArrayDeque<MessagePatternUtil.MessageNode>();
            messageNodes.push(MessagePatternUtil.buildMessageNode((String)message));
            while (!messageNodes.isEmpty()) {
                MessagePatternUtil.MessageNode messageNode = (MessagePatternUtil.MessageNode)messageNodes.pop();
                for (MessagePatternUtil.MessageContentsNode node : messageNode.getContents()) {
                    String typeName;
                    if (node.getType() != MessagePatternUtil.MessageContentsNode.Type.ARG) continue;
                    MessagePatternUtil.ArgNode argNode = (MessagePatternUtil.ArgNode)node;
                    MessagePatternUtil.ComplexArgStyleNode complexStyle = argNode.getComplexStyle();
                    if (complexStyle != null) {
                        for (MessagePatternUtil.VariantNode variantNode : complexStyle.getVariants()) {
                            messageNodes.push(variantNode.getMessage());
                        }
                    }
                    if (argNode.getNumber() > maxIndex) {
                        maxIndex = argNode.getNumber();
                    }
                    if ((typeName = argNode.getTypeName()) == null) continue;
                    String argType = null;
                    if (argTypes.length > argNode.getNumber()) {
                        argType = argTypes[argNode.getNumber()];
                    }
                    IcuMessageFormatSupport.checkTypeName(typeName, argType, argTypeChecker, errors);
                }
            }
            int usedArgCount = maxIndex + 1;
            int n = argCount = argTypes == null ? 0 : argTypes.length;
            if (usedArgCount > argCount) {
                errors.add(String.format("The message uses more arguments (%d) than are declared (%d)", usedArgCount, argCount));
            }
        }
        return errors;
    }

    private static void checkTypeName(String argType, String argJavaType, MessageFormatSupport.TypeChecker argTypeChecker, List<String> errors) {
        Set expectedJavaTypes = ARGTYPE_TO_JAVA_MAPPING.get((Object)argType);
        if (!argTypeChecker.isCompatibleWith(argJavaType, expectedJavaTypes)) {
            errors.add(String.format("The message format type %s does not match the expected argument types: %s", argType, StringUtils.join((Iterable)expectedJavaTypes, (String)",")));
        }
    }

    static {
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_NUMBER, Arrays.asList(Number.class.getName()));
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_NUMBER, JAVATYPES_CURRENCY);
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_DATE, Arrays.asList(Calendar.class.getName(), Number.class.getName()));
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_DATE, (Iterable)JAVATYPES_DATETIME);
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_DATE, (Iterable)JAVATYPES_DATE);
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_DATE, (Iterable)JAVATYPES_TIME);
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_TIME, Arrays.asList(Calendar.class.getName(), Number.class.getName()));
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_TIME, (Iterable)JAVATYPES_DATETIME);
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_TIME, (Iterable)JAVATYPES_DATE);
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)ARGTYPE_TIME, (Iterable)JAVATYPES_TIME);
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)"spellout", Arrays.asList(Number.class.getName()));
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)"ordinal", Arrays.asList(Number.class.getName()));
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)"duration", Arrays.asList(Number.class.getName()));
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)"plural", Arrays.asList(Number.class.getName()));
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)"select", Arrays.asList(String.class.getName()));
        ARGTYPE_TO_JAVA_MAPPING.putAll((Object)"choice", Arrays.asList(Number.class.getName()));
        JAVA_TO_ARGTYPE__MAPPING = new HashMap<String, String>();
        JAVATYPES_INTEGER.forEach(type -> JAVA_TO_ARGTYPE__MAPPING.put((String)type, ARGTYPE_NUMBER));
        JAVATYPES_DECIMAL.forEach(type -> JAVA_TO_ARGTYPE__MAPPING.put((String)type, ARGTYPE_NUMBER));
        JAVATYPES_CURRENCY.forEach(type -> JAVA_TO_ARGTYPE__MAPPING.put((String)type, "number,currency"));
        JAVATYPES_DATETIME.forEach(type -> JAVA_TO_ARGTYPE__MAPPING.put((String)type, ARGTYPE_DATE));
        JAVATYPES_DATE.forEach(type -> JAVA_TO_ARGTYPE__MAPPING.put((String)type, ARGTYPE_DATE));
        JAVA_TO_ARGTYPE__MAPPING.put(Calendar.class.getName(), ARGTYPE_DATE);
        JAVATYPES_TIME.forEach(type -> JAVA_TO_ARGTYPE__MAPPING.put((String)type, ARGTYPE_TIME));
    }
}

