/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.impl;

import de.codecamp.messages.ResolvableMessage;
import de.codecamp.messages.runtime.MessageFormatFactory;
import de.codecamp.messages.spring.MessageArgConverterRegistry;
import de.codecamp.messages.spring.impl.MessageFormatAdapter;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtendedMessageSourceSupport {
    private static final String ZERO_WIDTH_SPACE = "\u200b";
    private Log MISSING_LOG = LogFactory.getLog((String)"de.codecamp.messages.missing");
    private MessageFormatFactory messageFormatFactory;
    private MessageArgConverterRegistry messageArgConverterRegistry;
    private Set<Locale> availableLocales = Collections.emptySet();
    private Locale defaultLocale;
    private boolean fallbackToDefaultLocale = true;
    private boolean logWhenMissing = true;
    private boolean logWhenNullArg = true;
    private Set<String> missingMessages = ConcurrentHashMap.newKeySet();

    public MessageFormatFactory getMessageFormatFactory() {
        return this.messageFormatFactory;
    }

    public void setMessageFormatFactory(MessageFormatFactory messageFormatFactory) {
        this.messageFormatFactory = messageFormatFactory;
    }

    public MessageArgConverterRegistry getMessageArgConverterRegistry() {
        return this.messageArgConverterRegistry;
    }

    public void setMessageArgConverterRegistry(MessageArgConverterRegistry messageArgConverterRegistry) {
        this.messageArgConverterRegistry = messageArgConverterRegistry;
    }

    public boolean isFallbackToDefaultLocale() {
        return this.fallbackToDefaultLocale;
    }

    public void setFallbackToDefaultLocale(boolean fallbackToDefaultLocale) {
        this.fallbackToDefaultLocale = fallbackToDefaultLocale;
    }

    public boolean isLogWhenMissing() {
        return this.logWhenMissing;
    }

    public void setLogWhenMissing(boolean logWhenMissing) {
        this.logWhenMissing = logWhenMissing;
    }

    public boolean isLogWhenNullArg() {
        return this.logWhenNullArg;
    }

    public void setLogWhenNullArg(boolean logWhenNullArg) {
        this.logWhenNullArg = logWhenNullArg;
    }

    public Set<Locale> getAvailableLocales() {
        return this.availableLocales;
    }

    public void setAvailableLocales(Set<Locale> availableLocales) {
        this.availableLocales = Collections.unmodifiableSet(new HashSet<Locale>(availableLocales));
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public String getMessageInternal(String code, Object[] args, Locale locale, GetMessageInternalDelegate internalMessageDelegate, GetDefaultMessageDelegate defaultMessageDelegate) {
        String message;
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        if (args != null && this.isLogWhenNullArg()) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg != null) continue;
                String msg = "Message argument at index %s was null for message key '%s'.";
                msg = String.format(msg, i, code);
                this.MISSING_LOG.error((Object)msg);
            }
        }
        if ((message = internalMessageDelegate.getMessageInternal(code, new Object[]{args}, locale)) == null || message.isEmpty()) {
            if (this.isLogWhenMissing() && this.missingMessages.add(code)) {
                String msg = "At least one localization missing for message key '%s'.";
                msg = String.format(msg, code);
                this.MISSING_LOG.error((Object)msg);
            }
            if (this.isFallbackToDefaultLocale() && !locale.equals(this.getDefaultLocale())) {
                message = internalMessageDelegate.getMessageInternal(code, new Object[]{args}, this.getDefaultLocale());
            }
        }
        if (message == null || message.isEmpty()) {
            message = defaultMessageDelegate.getDefaultMessage(code);
        }
        if (message != null && message.isEmpty()) {
            message = null;
        }
        if (ZERO_WIDTH_SPACE.equals(message)) {
            message = "";
        }
        return message;
    }

    public final MessageFormat createMessageFormat(final String message, final Locale locale) {
        return new MessageFormatAdapter(){
            Format mf;
            {
                this.mf = ExtendedMessageSourceSupport.this.messageFormatFactory.createFormat(message, locale);
            }

            @Override
            protected StringBuffer wrappedFormat(Object obj, StringBuffer result, FieldPosition pos) {
                Object[] args = (Object[])obj;
                if (args != null && args.length == 1) {
                    if (args[0] instanceof ResolvableMessage) {
                        ResolvableMessage resolvableMessage = (ResolvableMessage)args[0];
                        if (ExtendedMessageSourceSupport.this.messageFormatFactory.hasNamedArgsSupport()) {
                            Map<String, Object> argsByName = ExtendedMessageSourceSupport.this.getMessageArgConverterRegistry().convertValues(resolvableMessage.getArgsByName(true), this.getLocale());
                            return this.mf.format(argsByName, result, pos);
                        }
                        Object[] argsByIndex = ExtendedMessageSourceSupport.this.getMessageArgConverterRegistry().convertValues(resolvableMessage.getArgsByIndex(), this.getLocale()).toArray();
                        return this.mf.format(argsByIndex, result, pos);
                    }
                    if (args[0] instanceof Map) {
                        if (ExtendedMessageSourceSupport.this.messageFormatFactory.hasNamedArgsSupport()) {
                            Map<String, Object> argsByName = ExtendedMessageSourceSupport.this.getMessageArgConverterRegistry().convertValues((Map)args[0], this.getLocale());
                            return this.mf.format(argsByName, result, pos);
                        }
                        throw new UnsupportedOperationException("Named message arguments not supported.");
                    }
                }
                if (args != null && args.length == 0) {
                    args = null;
                }
                args = ExtendedMessageSourceSupport.this.getMessageArgConverterRegistry().convertValues(args, this.getLocale());
                return this.mf.format(args, result, pos);
            }
        };
    }

    @FunctionalInterface
    public static interface GetMessageInternalDelegate {
        public String getMessageInternal(String var1, Object[] var2, Locale var3);
    }

    @FunctionalInterface
    public static interface GetDefaultMessageDelegate {
        public String getDefaultMessage(String var1);
    }
}

