/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring;

import de.codecamp.messages.proxy.MessageProxy;
import de.codecamp.messages.proxy.MessageProxyUtils;
import de.codecamp.messages.proxy.NamedArgsMessageProvider;
import de.codecamp.messages.spring.MessageAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.LocaleUtils;
import org.springframework.util.ReflectionUtils;

public final class MessageAccessUtils {
    private MessageAccessUtils() {
    }

    public static Locale[] getCandidateLocales(MessageAccessor messageAccessor, boolean includeParentLevels) {
        Locale contextLocale = messageAccessor.getLocale();
        Locale defaultLocale = messageAccessor.getDefaultLocale();
        if (includeParentLevels) {
            LinkedHashSet locales = new LinkedHashSet();
            locales.addAll(LocaleUtils.localeLookupList((Locale)contextLocale));
            locales.addAll(LocaleUtils.localeLookupList((Locale)defaultLocale));
            return locales.toArray(new Locale[locales.size()]);
        }
        if (!Objects.equals(contextLocale, defaultLocale)) {
            return new Locale[]{contextLocale, defaultLocale};
        }
        return new Locale[]{contextLocale};
    }

    public static void injectMessageProxies(Object bean, NamedArgsMessageProvider messageProvider) {
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            if (!MessageProxy.class.isAssignableFrom(field.getType())) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            if (ReflectionUtils.getField((Field)field, (Object)bean) != null) {
                return;
            }
            Class<MessageProxy> messageProxyType = field.getType().asSubclass(MessageProxy.class);
            MessageProxy messageProxy = MessageProxyUtils.createNamedArgsMessageProxy(messageProxyType, (NamedArgsMessageProvider)messageProvider);
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)messageProxy);
        }, field -> !Modifier.isStatic(field.getModifiers()));
    }
}

