/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.autoconfigure;

import com.ibm.icu.text.MessageFormat;
import de.codecamp.messages.runtime.DefaultMessageArgConverter;
import de.codecamp.messages.runtime.DefaultMessageFormatFactory;
import de.codecamp.messages.runtime.IcuJavaMoneyMessageArgConverter;
import de.codecamp.messages.runtime.IcuMessageArgConverter;
import de.codecamp.messages.runtime.IcuMessageFormatFactory;
import de.codecamp.messages.runtime.MessageArgConverter;
import de.codecamp.messages.runtime.MessageFormatFactory;
import de.codecamp.messages.spring.ExtendedMessageSource;
import de.codecamp.messages.spring.ExtendedResourceBundleMessageSource;
import de.codecamp.messages.spring.MessageAccessor;
import de.codecamp.messages.spring.MessageArgConverterRegistry;
import de.codecamp.messages.spring.autoconfigure.ExtendedMessageSourceProperties;
import de.codecamp.messages.spring.impl.MessageArgConverterRegistryImpl;
import de.codecamp.messages.spring.impl.MessageProxyInjectingBeanPostProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={MessageSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={ExtendedMessageSourceProperties.class})
public class MessagesAutoConfiguration {
    private static final Log LOG = LogFactory.getLog(MessagesAutoConfiguration.class);
    private ApplicationContext applicationContext;
    private ExtendedMessageSourceProperties properties;

    public MessagesAutoConfiguration(ApplicationContext applicationContext, ExtendedMessageSourceProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Bean(name={"messageSource"})
    public ExtendedMessageSource messageSource(MessageFormatFactory messageFormatFactory, MessageArgConverterRegistry messageArgConverterRegistry) {
        Duration cacheDuration;
        String msg;
        LinkedHashSet<String> bundleBasenames = new LinkedHashSet<String>();
        LinkedHashSet<Object> bundleLocales = new LinkedHashSet<Locale>();
        ArrayList<String> patterns = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty((Object[])this.properties.getAvailableLocales())) {
            LOG.debug((Object)"Available message bundle locales explicitly configured. Autodiscovery disabled.");
            bundleLocales.addAll(Arrays.asList(this.properties.getAvailableLocales()));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties.getBasenames())) {
            bundleBasenames.addAll(Arrays.asList(this.properties.getBasenames()));
            if (bundleLocales.isEmpty()) {
                Stream.of(bundleBasenames).map(basename -> "classpath*:" + basename + "_*.properties").forEach(patterns::add);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties.getBundleFilePatterns())) {
            patterns.addAll(Arrays.asList(this.properties.getBundleFilePatterns()));
        }
        if (!patterns.isEmpty()) {
            LinkedHashSet<String> bundleNamesTemp = new LinkedHashSet<String>();
            LinkedHashSet<Locale> bundleLocalesTemp = new LinkedHashSet<Locale>();
            for (String pattern : patterns) {
                this.discoverBundlesAndLocales((ResourcePatternResolver)this.applicationContext, pattern, bundleNamesTemp, bundleLocalesTemp);
            }
            if (bundleNamesTemp.isEmpty()) {
                if (bundleBasenames.isEmpty()) {
                    LOG.warn((Object)"No message bundle basenames discovered or configured.");
                }
            } else {
                bundleBasenames.addAll(bundleNamesTemp);
            }
            if (bundleLocalesTemp.isEmpty()) {
                if (bundleLocales.isEmpty()) {
                    LOG.warn((Object)"No message bundle locales discovered or configured.");
                }
            } else {
                bundleLocales = bundleLocalesTemp;
            }
        }
        String msg2 = "Available message bundles: %s";
        msg2 = String.format(msg2, StringUtils.join(bundleBasenames, (String)", "));
        LOG.info((Object)msg2);
        msg2 = "Available message bundle locales: %s";
        msg2 = String.format(msg2, StringUtils.join(bundleLocales, (String)", "));
        LOG.info((Object)msg2);
        ExtendedResourceBundleMessageSource messageSource = new ExtendedResourceBundleMessageSource();
        messageSource.setMessageFormatFactory(messageFormatFactory);
        messageSource.setMessageArgConverterRegistry(messageArgConverterRegistry);
        messageSource.setBasenames(bundleBasenames.toArray(new String[bundleBasenames.size()]));
        messageSource.setAvailableLocales(new ArrayList<Locale>(bundleLocales));
        Locale defaultLocale = this.properties.getDefaultLocale();
        if (defaultLocale == null) {
            for (Locale locale : LocaleUtils.localeLookupList((Locale)Locale.getDefault())) {
                if (!bundleLocales.contains(locale)) continue;
                defaultLocale = locale;
                break;
            }
            if (defaultLocale == null) {
                msg = "No explicit application default locale configured and the system default locale '%s' was not found among the discovered or configured locales: %s";
                msg = String.format(msg, Locale.getDefault(), bundleLocales.stream().map(Locale::toString).collect(Collectors.joining(", ")));
                throw new IllegalStateException(msg);
            }
            LOG.debug((Object)"No explicit application default locale configured. Using Locale.getDefault().");
        }
        if (Collections.disjoint(bundleLocales, LocaleUtils.localeLookupList((Locale)defaultLocale))) {
            msg = "The message bundle default locale '%s' was not found among the discovered or configured locales: %s";
            msg = String.format(msg, defaultLocale, bundleLocales.stream().map(Locale::toString).collect(Collectors.joining(", ")));
            throw new IllegalStateException(msg);
        }
        msg = "Application default locale: %s";
        msg = String.format(msg, defaultLocale);
        LOG.info((Object)msg);
        messageSource.setDefaultLocale(defaultLocale);
        if (this.properties.getEncoding() != null) {
            messageSource.setDefaultEncoding(this.properties.getEncoding().name());
        }
        if ((cacheDuration = this.properties.getCacheDuration()) != null) {
            messageSource.setCacheMillis(cacheDuration.toMillis());
        }
        messageSource.setFallbackToDefaultLocale(this.properties.isFallbackToDefaultLocale());
        messageSource.setLogWhenMissing(this.properties.isLogWhenMissing());
        messageSource.setUseCodeAsDefaultMessage(this.properties.isUseCodeWhenMissing());
        messageSource.setAlwaysUseMessageFormat(this.properties.isAlwaysUseMessageFormat());
        return messageSource;
    }

    private void discoverBundlesAndLocales(ResourcePatternResolver patternResolver, String pattern, Set<String> bundleNames, Set<Locale> bundleLocales) {
        try {
            Resource[] resources = patternResolver.getResources(pattern);
            if (resources.length == 0) {
                LOG.warn((Object)("No message bundles found for pattern: {}" + pattern));
            }
            for (Resource resource : resources) {
                String localeString;
                String msg;
                String bundlePath;
                if (resource instanceof FileSystemResource) {
                    File file = resource.getFile();
                    bundlePath = StringUtils.substringAfterLast((String)file.getAbsolutePath(), (String)"classes\\");
                    msg = "Found message bundle file %s -> %s.";
                    msg = String.format(msg, file.toString(), bundlePath);
                    LOG.debug((Object)msg);
                } else if (resource instanceof UrlResource) {
                    URL url = resource.getURL();
                    bundlePath = StringUtils.substringAfterLast((String)url.toString(), (String)"!/");
                    msg = "Found message bundle URL %s -> %s.";
                    msg = String.format(msg, url.toString(), bundlePath);
                    LOG.debug((Object)msg);
                } else {
                    String msg2 = "Resource type %s not yet supported for message bundle basename discovery.";
                    msg2 = String.format(msg2, resource.getClass().getName());
                    LOG.warn((Object)msg2);
                    bundlePath = null;
                }
                if (bundlePath == null || !bundlePath.endsWith(".properties")) continue;
                String bundlePathNoExt = StringUtils.removeEnd((String)bundlePath, (String)".properties");
                if (bundleNames != null) {
                    String bundleName = StringUtils.substringBefore((String)bundlePathNoExt, (String)"_");
                    bundleNames.add(bundleName);
                }
                if (bundleLocales == null || (localeString = StringUtils.substringAfter((String)bundlePathNoExt, (String)"_")).isEmpty()) continue;
                bundleLocales.add(LocaleUtils.toLocale((String)localeString));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to discover message bundle basenames.", ex);
        }
    }

    @Bean
    public MessageArgConverterRegistry messageArgConverterRegistry(List<MessageArgConverter> converters) {
        return new MessageArgConverterRegistryImpl(converters);
    }

    @Bean
    public MessageAccessor messageAccessor(ExtendedMessageSource messageSource) {
        return new MessageAccessor(messageSource);
    }

    @Bean
    public static BeanPostProcessor messageProxyInjectingBeanPostProcessor() {
        return new MessageProxyInjectingBeanPostProcessor();
    }

    @Bean
    @ConditionalOnProperty(prefix="codecamp.messages", name={"normalizeDefaultLocales"})
    public BeanPostProcessor staticDefaultLocaleInitializer() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof ExtendedMessageSource) {
                    Locale defaultLocale = ((ExtendedMessageSource)bean).getDefaultLocale();
                    LocaleContextHolder.setDefaultLocale((Locale)defaultLocale);
                    Locale.setDefault(defaultLocale);
                }
                return bean;
            }
        };
    }

    @Configuration
    @ConditionalOnMissingClass(value={"com.ibm.icu.text.MessageFormat"})
    @ConditionalOnMissingBean(value={MessageFormatFactory.class})
    protected static class DefaultMessageFormatConfiguration {
        protected DefaultMessageFormatConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MessageFormatFactory defaultMessageFormatFactory() {
            LOG.info((Object)String.format("Using regular %s.", java.text.MessageFormat.class.getName()));
            return new DefaultMessageFormatFactory();
        }

        @Bean
        public MessageArgConverter defaultJavaTimeMessageArgConverter() {
            return new DefaultMessageArgConverter(() -> LocaleContextHolder.getTimeZone());
        }
    }

    @Configuration
    @ConditionalOnClass(value={MessageFormat.class})
    @ConditionalOnMissingBean(value={MessageFormatFactory.class})
    protected static class IcuMessageFormatConfiguration {
        protected IcuMessageFormatConfiguration() {
        }

        @Bean
        public MessageFormatFactory icuMessageFormatFactory() {
            LOG.info((Object)String.format("ICU4J detected. Using %s.", MessageFormat.class.getName()));
            return new IcuMessageFormatFactory();
        }

        @Bean
        public MessageArgConverter icuJavaTimeMessageArgConverter() {
            return new IcuMessageArgConverter(() -> LocaleContextHolder.getTimeZone());
        }

        @Bean
        @ConditionalOnClass(name={"javax.money.MonetaryAmount"})
        public MessageArgConverter icuJavaMoneyMessageArgConverter() {
            return new IcuJavaMoneyMessageArgConverter();
        }
    }
}

