/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring;

import de.codecamp.messages.HasMessages;
import de.codecamp.messages.spring.ExtendedMessageSource;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.LocaleUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;

public class MessageAccessor
implements HasMessages {
    protected final ExtendedMessageSource messageSource;
    private Locale locale;

    public MessageAccessor(ExtendedMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private MessageAccessor(ExtendedMessageSource messageSource, Locale locale) {
        this(messageSource);
        Assert.notNull((Object)locale, (String)"locale must not be null");
        this.locale = locale;
    }

    public List<Locale> getAvailableLocales() {
        return this.messageSource.getAvailableLocales();
    }

    public Locale getDefaultLocale() {
        return Optional.ofNullable(LocaleContextHolder.getLocaleContext()).map(LocaleContext::getLocale).orElse(this.messageSource.getDefaultLocale());
    }

    public Locale[] getCandidateLocales() {
        return this.getCandidateLocales(false);
    }

    public Locale[] getCandidateLocales(boolean includeParentLevels) {
        Locale contextLocale = null;
        if (LocaleContextHolder.getLocaleContext() != null) {
            contextLocale = LocaleContextHolder.getLocaleContext().getLocale();
        }
        Locale defaultLocale = this.messageSource.getDefaultLocale();
        if (includeParentLevels) {
            LinkedHashSet locales = new LinkedHashSet();
            if (contextLocale != null) {
                locales.addAll(LocaleUtils.localeLookupList((Locale)contextLocale));
            }
            locales.addAll(LocaleUtils.localeLookupList((Locale)defaultLocale));
            return locales.toArray(new Locale[locales.size()]);
        }
        if (contextLocale != null) {
            return new Locale[]{contextLocale, defaultLocale};
        }
        return new Locale[]{defaultLocale};
    }

    private Locale getEffectiveLocale() {
        return this.locale != null ? this.locale : this.getDefaultLocale();
    }

    public String getMessage(String messageKey, Object ... args) {
        return this.messageSource.getMessage(messageKey, args, this.getEffectiveLocale());
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, this.getEffectiveLocale());
    }

    public MessageAccessor forLocale(Locale locale) {
        return new MessageAccessor(this.messageSource, locale);
    }
}

