/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.autoconfigure;

import de.codecamp.messages.ResolvableMessage;
import de.codecamp.messages.codegen.MessageProxyInterface;
import de.codecamp.messages.proxy.MessageProxyUtils;
import de.codecamp.messages.proxy.NamedArgsMessageProvider;
import de.codecamp.messages.spring.MessageAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class MessageProxyImportBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware,
BeanClassLoaderAware,
ResourceLoaderAware {
    private static final String PROP_MESSAGE_PROXY_BASE_PACKAGES = "codecamp.messages.message-proxy-base-packages";
    private static final Log LOG = LogFactory.getLog(MessageProxyImportBeanDefinitionRegistrar.class);
    private Environment environment;
    private BeanFactory beanFactory;
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Object[] scanPackages = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)this.environment.getProperty(PROP_MESSAGE_PROXY_BASE_PACKAGES)));
        if (scanPackages.length > 0) {
            int proxiesFound = 0;
            LOG.info((Object)String.format("Scanning for message proxies in: %s.", StringUtils.arrayToCommaDelimitedString((Object[])scanPackages)));
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false){

                protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                    AnnotationMetadata metadata = beanDefinition.getMetadata();
                    return metadata.isIndependent();
                }
            };
            scanner.setEnvironment(this.environment);
            scanner.setResourceLoader(this.resourceLoader);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(MessageProxyInterface.class, true, true));
            LateBindingNamedArgsMessageProvider messageProvider = new LateBindingNamedArgsMessageProvider(this.beanFactory);
            for (Object scanPackage : scanPackages) {
                for (BeanDefinition candidate : scanner.findCandidateComponents((String)scanPackage)) {
                    try {
                        Class<?> messageProxyType = this.classLoader.loadClass(candidate.getBeanClassName());
                        if (!messageProxyType.isInterface()) continue;
                        GenericBeanDefinition beanDef = new GenericBeanDefinition(candidate);
                        beanDef.setLazyInit(true);
                        beanDef.setInstanceSupplier(() -> MessageProxyUtils.createNamedArgsMessageProxy((Class)messageProxyType, (NamedArgsMessageProvider)messageProvider));
                        MessageProxyInterface messageProxyAt = messageProxyType.getAnnotation(MessageProxyInterface.class);
                        if (messageProxyAt != null && messageProxyAt.sourceType() != Void.class) {
                            beanDef.setPrimary(true);
                        }
                        registry.registerBeanDefinition(candidate.getBeanClassName(), (BeanDefinition)beanDef);
                        ++proxiesFound;
                        LOG.debug((Object)String.format("Message proxy interface '%s' registered as bean.", candidate.getBeanClassName()));
                    }
                    catch (ClassNotFoundException ex) {
                        LOG.error((Object)String.format("Failed to load message proxy class '%s'.", candidate.getBeanClassName()), (Throwable)ex);
                    }
                }
            }
            LOG.info((Object)String.format("%d message proxies found.", proxiesFound));
        }
    }

    private static class LateBindingNamedArgsMessageProvider
    implements NamedArgsMessageProvider {
        private MessageAccessor msgs;
        private BeanFactory beanFactory;

        public LateBindingNamedArgsMessageProvider(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public String getMessage(ResolvableMessage resolvableMessage) {
            if (this.msgs == null) {
                this.msgs = (MessageAccessor)this.beanFactory.getBean(MessageAccessor.class);
                this.beanFactory = null;
            }
            return this.msgs.getMessage(resolvableMessage);
        }
    }
}

