/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.impl;

import de.codecamp.messages.proxy.MessageProxy;
import de.codecamp.messages.proxy.MessageProxyUtils;
import de.codecamp.messages.spring.MessageAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.ReflectionUtils;

public class MessageProxyInjectingBeanPostProcessor
implements BeanPostProcessor {
    @Autowired
    @Lazy
    private MessageAccessor messageAccessor;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        String beanClassName = bean.getClass().getName();
        if (beanClassName.startsWith("org.springframework.")) {
            return bean;
        }
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            if (!MessageProxy.class.isAssignableFrom(field.getType())) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            if (ReflectionUtils.getField((Field)field, (Object)bean) != null) {
                return;
            }
            Class<MessageProxy> messageProxyType = field.getType().asSubclass(MessageProxy.class);
            MessageProxy messageProxy = MessageProxyUtils.createNamedArgsMessageProxy(messageProxyType, arg_0 -> ((MessageAccessor)this.messageAccessor).getMessage(arg_0));
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)messageProxy);
        }, field -> !Modifier.isStatic(field.getModifiers()));
        return bean;
    }
}

