/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring;

import de.codecamp.messages.spring.ExtendedMessageSource;
import de.codecamp.messages.spring.MessageAccessor;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;

public class DefaultMessageAccessor
implements MessageAccessor {
    protected final ExtendedMessageSource messageSource;
    private final Locale locale;

    public DefaultMessageAccessor(ExtendedMessageSource messageSource) {
        this.messageSource = Objects.requireNonNull(messageSource, "messageSource must not be null");
        this.locale = null;
    }

    private DefaultMessageAccessor(ExtendedMessageSource messageSource, Locale locale) {
        this.messageSource = Objects.requireNonNull(messageSource, "messageSource must not be null");
        this.locale = Objects.requireNonNull(locale, "locale must not be null");
    }

    @Override
    public Set<Locale> getAvailableLocales() {
        return this.messageSource.getAvailableLocales();
    }

    @Override
    public Locale getDefaultLocale() {
        return Optional.ofNullable(LocaleContextHolder.getLocaleContext()).map(LocaleContext::getLocale).orElse(this.messageSource.getDefaultLocale());
    }

    @Override
    public Locale getLocale() {
        return Optional.ofNullable(this.locale).or(() -> Optional.ofNullable(LocaleContextHolder.getLocaleContext()).map(LocaleContext::getLocale)).orElseGet(() -> this.getDefaultLocale());
    }

    @Override
    public String getMessage(String messageKey, Object ... args) {
        return this.messageSource.getMessage(messageKey, args, this.getLocale());
    }

    @Override
    public DefaultMessageAccessor forLocale(Locale locale) {
        return new DefaultMessageAccessor(this.messageSource, locale);
    }
}

