/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.impl;

import de.codecamp.messages.spring.DefaultMessageAccessor;
import de.codecamp.messages.spring.MessageAccessUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Lazy;

public class MessageProxyInjectingBeanPostProcessor
implements BeanPostProcessor {
    @Autowired
    @Lazy
    private DefaultMessageAccessor messageAccessor;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        String beanClassName = bean.getClass().getName();
        if (beanClassName.startsWith("org.springframework.")) {
            return bean;
        }
        MessageAccessUtils.injectMessageProxies(bean, this.messageAccessor::getMessage);
        return bean;
    }
}

