/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.impl;

import de.codecamp.messages.runtime.MessageArgConverter;
import de.codecamp.messages.spring.MessageArgConverterRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MessageArgConverterRegistryImpl
implements MessageArgConverterRegistry {
    private final List<MessageArgConverter> converters;

    public MessageArgConverterRegistryImpl(List<MessageArgConverter> converters) {
        this.converters = converters;
    }

    @Override
    public Map<String, Object> convertValues(Map<String, Object> args, Locale locale) {
        if (this.converters == null || this.converters.isEmpty() || args == null || args.isEmpty()) {
            return args;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(args.size());
        args.forEach((key, value) -> result.put((String)key, this.convertValue(value, locale)));
        return result;
    }

    @Override
    public List<Object> convertValues(List<Object> args, Locale locale) {
        if (this.converters == null || this.converters.isEmpty() || args == null || args.isEmpty()) {
            return args;
        }
        ArrayList<Object> result = new ArrayList<Object>(args.size());
        args.forEach(value -> result.add(this.convertValue(value, locale)));
        return result;
    }

    @Override
    public Object[] convertValues(Object[] args, Locale locale) {
        if (this.converters == null || this.converters.isEmpty() || args == null || args.length == 0) {
            return args;
        }
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.convertValue(args[i], locale);
        }
        return result;
    }

    private Object convertValue(Object value, Locale locale) {
        if (this.converters == null || this.converters.isEmpty()) {
            return value;
        }
        for (MessageArgConverter converter : this.converters) {
            value = converter.convert(value, locale);
        }
        return value;
    }
}

