/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring;

import de.codecamp.messages.ResolvableMessage;
import de.codecamp.messages.spring.impl.TimeZonePassThrough;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.context.MessageSource;
import org.springframework.lang.Nullable;

public interface ExtendedMessageSource
extends MessageSource {
    public Set<Locale> getAvailableLocales();

    public Locale getDefaultLocale();

    public ZoneId getDefaultTimeZone();

    public void setDefaultTimeZone(ZoneId var1);

    default public String getMessage(String code, @Nullable Object[] args, Locale locale, ZoneId timeZone) {
        return TimeZonePassThrough.withTimeZone(timeZone, () -> this.getMessage(code, args, locale));
    }

    default public String getMessage(String code, @Nullable Map<String, Object> args, @Nullable Locale locale, @Nullable ZoneId timeZone) {
        return TimeZonePassThrough.withTimeZone(timeZone, () -> this.getMessage(code, new Object[]{args}, locale));
    }

    @Nullable
    default public String getMessage(String code, @Nullable Map<String, Object> args, @Nullable String defaultMessage, @Nullable Locale locale, @Nullable ZoneId timeZone) {
        return TimeZonePassThrough.withTimeZone(timeZone, () -> this.getMessage(code, new Object[]{args}, defaultMessage, locale));
    }

    default public String getMessage(ResolvableMessage resolvable, @Nullable Locale locale, @Nullable ZoneId timeZone) {
        return TimeZonePassThrough.withTimeZone(timeZone, () -> this.getMessage(resolvable.getCode(), new Object[]{resolvable}, locale));
    }

    @Nullable
    default public String getMessage(ResolvableMessage resolvable, @Nullable String defaultMessage, @Nullable Locale locale, @Nullable ZoneId timeZone) {
        return TimeZonePassThrough.withTimeZone(timeZone, () -> this.getMessage(resolvable.getCode(), new Object[]{resolvable}, defaultMessage, locale));
    }
}

