/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.autoconfigure;

import jakarta.validation.constraints.Pattern;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="codecamp.messages")
public class ExtendedMessageSourceProperties {
    public static final String PREFIX = "codecamp.messages";
    private String[] basenames;
    private Locale[] availableLocales;
    private Locale defaultLocale;
    private ZoneId defaultTimeZone;
    private String[] bundleFilePatterns = new String[]{"classpath*:messages/**/*.properties"};
    private Charset encoding = StandardCharsets.UTF_8;
    private boolean fallbackToDefaultLocale = true;
    private boolean logWhenMissing = true;
    private boolean useCodeWhenMissing = true;
    private boolean shortenCodeWhenMissing = true;
    @Pattern(regexp=".*\\{code\\}.*")
    private @Pattern(regexp=".*\\{code\\}.*") String missingMessagePattern = "!{code}!";
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration cacheDuration;
    private boolean alwaysUseMessageFormat = false;
    private boolean normalizeDefaultLocales = true;

    public String[] getBasenames() {
        return this.basenames;
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    public Locale[] getAvailableLocales() {
        return this.availableLocales;
    }

    public void setAvailableLocales(Locale[] availableLocales) {
        this.availableLocales = availableLocales;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public ZoneId getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    public void setDefaultTimeZone(ZoneId defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    public String[] getBundleFilePatterns() {
        return this.bundleFilePatterns;
    }

    public void setBundleFilePatterns(String[] bundleFilePatterns) {
        this.bundleFilePatterns = bundleFilePatterns;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public boolean isFallbackToDefaultLocale() {
        return this.fallbackToDefaultLocale;
    }

    public void setFallbackToDefaultLocale(boolean fallbackToDefaultLocale) {
        this.fallbackToDefaultLocale = fallbackToDefaultLocale;
    }

    public boolean isLogWhenMissing() {
        return this.logWhenMissing;
    }

    public void setLogWhenMissing(boolean logWhenMissing) {
        this.logWhenMissing = logWhenMissing;
    }

    public boolean isUseCodeWhenMissing() {
        return this.useCodeWhenMissing;
    }

    public void setUseCodeWhenMissing(boolean useCodeWhenMissing) {
        this.useCodeWhenMissing = useCodeWhenMissing;
    }

    public boolean isShortenCodeWhenMissing() {
        return this.shortenCodeWhenMissing;
    }

    public void setShortenCodeWhenMissing(boolean shortenCodeWhenMissing) {
        this.shortenCodeWhenMissing = shortenCodeWhenMissing;
    }

    public String getMissingMessagePattern() {
        return this.missingMessagePattern;
    }

    public void setMissingMessagePattern(String missingCodePattern) {
        this.missingMessagePattern = missingCodePattern;
    }

    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(Duration cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    public boolean isAlwaysUseMessageFormat() {
        return this.alwaysUseMessageFormat;
    }

    public void setAlwaysUseMessageFormat(boolean alwaysUseMessageFormat) {
        this.alwaysUseMessageFormat = alwaysUseMessageFormat;
    }

    public boolean isNormalizeDefaultLocales() {
        return this.normalizeDefaultLocales;
    }

    public void setNormalizeDefaultLocales(boolean normalizeDefaultLocales) {
        this.normalizeDefaultLocales = normalizeDefaultLocales;
    }
}

