/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring;

import de.codecamp.messages.spring.ExtendedMessageSource;
import de.codecamp.messages.spring.MessageAccessor;
import java.time.ZoneId;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.LocaleUtils;

public abstract class AbstractMessageAccessor
implements MessageAccessor {
    protected final ExtendedMessageSource messageSource;
    protected final Locale locale;
    protected final ZoneId timeZone;

    protected AbstractMessageAccessor(ExtendedMessageSource messageSource) {
        this.messageSource = Objects.requireNonNull(messageSource, "messageSource must not be null");
        this.locale = null;
        this.timeZone = null;
    }

    protected AbstractMessageAccessor(ExtendedMessageSource messageSource, Locale locale, ZoneId timeZone) {
        this.messageSource = Objects.requireNonNull(messageSource, "messageSource must not be null");
        this.locale = Objects.requireNonNull(locale, "locale must not be null");
        this.timeZone = timeZone;
    }

    @Override
    public Set<Locale> getAvailableLocales() {
        return this.messageSource.getAvailableLocales();
    }

    @Override
    public Locale getDefaultLocale() {
        return this.messageSource.getDefaultLocale();
    }

    @Override
    public ZoneId getDefaultTimeZone() {
        return this.messageSource.getDefaultTimeZone();
    }

    @Override
    public Locale getLocale() {
        return Optional.ofNullable(this.locale).or(this::getContextualLocale).orElseGet(this::getDefaultLocale);
    }

    protected abstract Optional<Locale> getContextualLocale();

    @Override
    public ZoneId getTimeZone() {
        return Optional.ofNullable(this.timeZone).or(this::getContextualTimeZone).orElseGet(this::getDefaultTimeZone);
    }

    protected abstract Optional<ZoneId> getContextualTimeZone();

    @Override
    public Locale[] getCandidateLocales(boolean includeParentLevels) {
        Locale contextLocale = this.getLocale();
        Locale defaultLocale = this.getDefaultLocale();
        if (includeParentLevels) {
            LinkedHashSet locales = new LinkedHashSet();
            locales.addAll(LocaleUtils.localeLookupList((Locale)contextLocale));
            locales.addAll(LocaleUtils.localeLookupList((Locale)defaultLocale));
            return locales.toArray(new Locale[locales.size()]);
        }
        if (!Objects.equals(contextLocale, defaultLocale)) {
            return new Locale[]{contextLocale, defaultLocale};
        }
        return new Locale[]{contextLocale};
    }

    @Override
    public String getMessage(String messageKey, Object ... args) {
        return this.messageSource.getMessage(messageKey, args, this.getLocale(), this.getTimeZone());
    }
}

