/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring;

import de.codecamp.messages.spring.AbstractMessageAccessor;
import de.codecamp.messages.spring.ExtendedMessageSource;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;

public class DefaultMessageAccessor
extends AbstractMessageAccessor {
    public DefaultMessageAccessor(ExtendedMessageSource messageSource) {
        super(messageSource);
    }

    private DefaultMessageAccessor(ExtendedMessageSource messageSource, Locale locale, ZoneId timeZone) {
        super(messageSource, locale, timeZone);
    }

    @Override
    protected Optional<Locale> getContextualLocale() {
        return Optional.ofNullable(LocaleContextHolder.getLocaleContext()).map(LocaleContext::getLocale);
    }

    @Override
    protected Optional<ZoneId> getContextualTimeZone() {
        return Optional.ofNullable(LocaleContextHolder.getLocaleContext()).map(lc -> {
            TimeZone timeZone;
            if (lc instanceof TimeZoneAwareLocaleContext) {
                TimeZoneAwareLocaleContext tzalc = (TimeZoneAwareLocaleContext)lc;
                timeZone = tzalc.getTimeZone();
            } else {
                timeZone = null;
            }
            return timeZone;
        }).map(TimeZone::toZoneId);
    }

    @Override
    public DefaultMessageAccessor forLocale(Locale locale) {
        return new DefaultMessageAccessor(this.messageSource, locale, this.timeZone);
    }
}

