/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring;

import de.codecamp.messages.proxy.MessageProxy;
import de.codecamp.messages.proxy.MessageProxyUtils;
import de.codecamp.messages.proxy.NamedArgsMessageProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.springframework.util.ReflectionUtils;

public final class MessageAccessUtils {
    private MessageAccessUtils() {
    }

    public static void injectMessageProxies(Object bean, NamedArgsMessageProvider messageProvider) {
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            if (!MessageProxy.class.isAssignableFrom(field.getType())) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            if (ReflectionUtils.getField((Field)field, (Object)bean) != null) {
                return;
            }
            Class<MessageProxy> messageProxyType = field.getType().asSubclass(MessageProxy.class);
            MessageProxy messageProxy = MessageProxyUtils.createNamedArgsMessageProxy(messageProxyType, (NamedArgsMessageProvider)messageProvider);
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)messageProxy);
        }, field -> !Modifier.isStatic(field.getModifiers()));
    }
}

