/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.i18n.I18NProvider;
import de.codecamp.messages.ResolvableMessage;
import de.codecamp.messages.spring.ExtendedMessageSource;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;

public class MessageSourceI18NProvider
implements I18NProvider {
    private MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public List<Locale> getProvidedLocales() {
        if (this.messageSource instanceof ExtendedMessageSource) {
            return ((ExtendedMessageSource)this.messageSource).getAvailableLocales();
        }
        return null;
    }

    public String getTranslation(String key, Locale locale, Object ... params) {
        try {
            if (this.messageSource instanceof ExtendedMessageSource && params != null && params.length == 1) {
                ExtendedMessageSource extendedMessageSource = (ExtendedMessageSource)this.messageSource;
                if (params[0] instanceof ResolvableMessage) {
                    return extendedMessageSource.getMessage((ResolvableMessage)params[0], locale);
                }
                if (params[0] instanceof Map) {
                    Map args = (Map)params[0];
                    return extendedMessageSource.getMessage(key, args, locale);
                }
            }
            return this.messageSource.getMessage(key, params, locale);
        }
        catch (NoSuchMessageException ex) {
            return "!{" + key + " -> " + locale + "}!";
        }
    }
}

