/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.component.Component;
import de.codecamp.messages.MessageKeyUtils;
import de.codecamp.messages.Messages;
import de.codecamp.messages.ResolvableMessage;
import de.codecamp.messages.spring.vaadin.annotations.LocalizedProperty;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;

public class I18n {
    private static final Log LOG = LogFactory.getLog(I18n.class);

    public static void updateLocalized(Component component, Consumer<String> setter, ResolvableMessage messageKey) {
        String message = component.getTranslation(messageKey.getCode(), new Object[]{messageKey});
        setter.accept(message);
    }

    public static void localizeFields(Component component) {
        Class<?> superclass;
        Class<Object> componentClass = component.getClass();
        do {
            for (Field field : componentClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                for (Annotation fieldAnnotation : field.getAnnotations()) {
                    if (!fieldAnnotation.annotationType().isAnnotationPresent(LocalizedProperty.class)) continue;
                    Messages messages = fieldAnnotation.annotationType().getAnnotation(Messages.class);
                    if (messages == null) {
                        String msg = "The annotation type %s is marked with @LocalizedProperty but does not have a @Messages annotation.";
                        msg = String.format(msg, fieldAnnotation.annotationType().getName());
                        LOG.error((Object)msg);
                        continue;
                    }
                    try {
                        field.setAccessible(true);
                        Object fieldObject = field.get(component);
                        if (fieldObject == null) continue;
                        ArrayList<String> keys = new ArrayList<String>();
                        keys.addAll(Arrays.asList(messages.keys()));
                        keys.addAll(Arrays.asList(messages.value()));
                        for (String propertyName : keys) {
                            Method setter;
                            PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(fieldObject.getClass(), (String)propertyName);
                            if (propertyDescriptor == null || (setter = propertyDescriptor.getWriteMethod()) == null) continue;
                            String text = component.getTranslation(MessageKeyUtils.getKeyFor(component.getClass(), (String)field.getName(), (String)propertyName), new Object[0]);
                            setter.invoke(fieldObject, text);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException ex) {
                        String msg = "Failed to localize '%s' in '%s'.";
                        msg = String.format(msg, field.getName(), component.getClass().getName());
                        throw new IllegalStateException(msg, ex);
                    }
                }
            }
        } while ((componentClass = Component.class.isAssignableFrom(superclass = componentClass.getSuperclass()) ? superclass.asSubclass(Component.class) : null) != null);
    }
}

