/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.component.Component;
import de.codecamp.messages.MessageKeyUtils;
import de.codecamp.messages.Messages;
import de.codecamp.messages.proxy.MessageProxy;
import de.codecamp.messages.proxy.MessageProxyUtils;
import de.codecamp.messages.spring.vaadin.annotations.LocalizedProperty;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

public class TranslationUtils {
    private static final Log LOG = LogFactory.getLog(TranslationUtils.class);

    public static void localizeComponents(Component component) {
        ReflectionUtils.doWithFields(component.getClass(), field -> TranslationUtils.processFieldForTranslatableComponent(component, field), field -> !Modifier.isStatic(field.getModifiers()));
    }

    public static void injectMessageProxies(Component component) {
        ReflectionUtils.doWithFields(component.getClass(), field -> TranslationUtils.processFieldForMessageProxies(component, field), field -> !Modifier.isStatic(field.getModifiers()));
    }

    private static void processFieldForMessageProxies(Component component, Field field) {
        if (!MessageProxy.class.isAssignableFrom(field.getType())) {
            return;
        }
        ReflectionUtils.makeAccessible((Field)field);
        if (ReflectionUtils.getField((Field)field, (Object)component) != null) {
            return;
        }
        Class<MessageProxy> messageProxyType = field.getType().asSubclass(MessageProxy.class);
        MessageProxy messageProxy = MessageProxyUtils.createNamedArgsMessageProxy(messageProxyType, resolvableMessage -> component.getTranslation(resolvableMessage.getCode(), new Object[]{resolvableMessage}));
        ReflectionUtils.setField((Field)field, (Object)component, (Object)messageProxy);
    }

    private static void processFieldForTranslatableComponent(Component component, Field field) {
        for (Annotation fieldAnnotation : field.getAnnotations()) {
            if (!fieldAnnotation.annotationType().isAnnotationPresent(LocalizedProperty.class)) continue;
            Messages messages = fieldAnnotation.annotationType().getAnnotation(Messages.class);
            if (messages == null) {
                String msg = "The annotation type %s is marked with @LocalizedProperty but does not have a @Messages annotation.";
                msg = String.format(msg, fieldAnnotation.annotationType().getName());
                LOG.error((Object)msg);
                continue;
            }
            try {
                ReflectionUtils.makeAccessible((Field)field);
                Object fieldObject = ReflectionUtils.getField((Field)field, (Object)component);
                if (fieldObject == null) continue;
                ArrayList<String> keys = new ArrayList<String>();
                keys.addAll(Arrays.asList(messages.keys()));
                keys.addAll(Arrays.asList(messages.value()));
                for (String propertyName : keys) {
                    Method setter;
                    PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(fieldObject.getClass(), (String)propertyName);
                    if (propertyDescriptor == null || (setter = propertyDescriptor.getWriteMethod()) == null) continue;
                    String text = component.getTranslation(MessageKeyUtils.getKeyFor(component.getClass(), (String)field.getName(), (String)propertyName), new Object[0]);
                    setter.invoke(fieldObject, text);
                }
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                String msg = "Failed to localize '%s' in '%s'.";
                msg = String.format(msg, field.getName(), component.getClass().getName());
                throw new IllegalStateException(msg, ex);
            }
        }
    }
}

