/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import de.codecamp.messages.MessageKeyUtils;
import de.codecamp.messages.Messages;
import de.codecamp.messages.proxy.MessageProxy;
import de.codecamp.messages.proxy.MessageProxyUtils;
import de.codecamp.messages.proxy.NamedArgsMessageProvider;
import de.codecamp.messages.spring.MessageAccessUtils;
import de.codecamp.messages.spring.MessageAccessor;
import de.codecamp.messages.spring.vaadin.LocalizationException;
import de.codecamp.messages.spring.vaadin.VaadinMessageAccessor;
import de.codecamp.messages.spring.vaadin.annotations.LocalizedProperty;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

public class LocalizationUtils {
    public static Locale[] getCandidateLocales(boolean includeParentLevels) {
        return MessageAccessUtils.getCandidateLocales((MessageAccessor)LocalizationUtils.getL10n(), (boolean)includeParentLevels);
    }

    public static void localizeComponents(Component composite) {
        ReflectionUtils.doWithFields(composite.getClass(), field -> LocalizationUtils.processFieldForLocalizableComponent(composite, field), field -> !Modifier.isStatic(field.getModifiers()));
    }

    public static void injectMessageProxies(Component component) {
        ReflectionUtils.doWithFields(component.getClass(), field -> LocalizationUtils.processFieldForMessageProxies(component, field), field -> !Modifier.isStatic(field.getModifiers()));
    }

    private static void processFieldForMessageProxies(Component component, Field field) {
        if (!MessageProxy.class.isAssignableFrom(field.getType())) {
            return;
        }
        ReflectionUtils.makeAccessible((Field)field);
        if (ReflectionUtils.getField((Field)field, (Object)component) != null) {
            return;
        }
        Class<MessageProxy> messageProxyType = field.getType().asSubclass(MessageProxy.class);
        MessageProxy messageProxy = MessageProxyUtils.createNamedArgsMessageProxy(messageProxyType, (NamedArgsMessageProvider & Serializable)resolvableMessage -> component.getTranslation(resolvableMessage.getCode(), new Object[]{resolvableMessage}));
        ReflectionUtils.setField((Field)field, (Object)component, (Object)messageProxy);
    }

    private static void processFieldForLocalizableComponent(Component composite, Field field) {
        try {
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldObject = ReflectionUtils.getField((Field)field, (Object)composite);
            if (fieldObject == null) {
                return;
            }
            HashSet<String> processedProperties = new HashSet<String>();
            LocalizationUtils.processContext(composite, field, fieldObject, null, null, field, "[Field " + field.getName() + " in " + composite.getClass().getName() + "]", processedProperties);
            for (Annotation fieldAnnotation : field.getAnnotations()) {
                String overrideProperty = LocalizationUtils.readOverridePropertyOrKey(fieldAnnotation, "property");
                String overrideKey = LocalizationUtils.readOverridePropertyOrKey(fieldAnnotation, "key");
                LocalizationUtils.processContext(composite, field, fieldObject, overrideProperty, overrideKey, fieldAnnotation.annotationType(), "[Annotation @" + fieldAnnotation.annotationType().getSimpleName() + "]", processedProperties);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            String msg = "Failed to localize '%s' in '%s'.";
            msg = String.format(msg, field.getName(), composite.getClass().getName());
            throw new IllegalStateException(msg, ex);
        }
    }

    private static String readOverridePropertyOrKey(Annotation annotation, String attributeName) {
        try {
            Method method = annotation.getClass().getMethod(attributeName, new Class[0]);
            if (method.getReturnType() != String.class || method.getParameterCount() != 0) {
                return null;
            }
            String value = (String)method.invoke((Object)annotation, new Object[0]);
            if (value.isEmpty()) {
                value = null;
            }
            return value;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            return null;
        }
    }

    private static void processContext(Component composite, Field field, Object fieldObject, String overrideProperty, String overrideKey, AnnotatedElement context, String contextInfo, Set<String> processedProperties) throws IllegalAccessException, InvocationTargetException {
        LocalizedProperty[] localizedPropertyAts = (LocalizedProperty[])context.getAnnotationsByType(LocalizedProperty.class);
        if (localizedPropertyAts.length == 0) {
            return;
        }
        LinkedHashSet<String> localKeys = null;
        for (LocalizedProperty localizedPropertyAt : localizedPropertyAts) {
            String text;
            String msg;
            Messages messages;
            String msg2;
            String keyForProperty;
            String propertyName = overrideProperty == null ? localizedPropertyAt.property() : overrideProperty;
            String string = keyForProperty = overrideKey == null ? localizedPropertyAt.key() : overrideKey;
            if (propertyName.isEmpty()) {
                if (!keyForProperty.isEmpty()) {
                    msg2 = "When 'property' is empty on @LocalizedProperty, then 'key' must also be empty. " + contextInfo;
                    throw new LocalizationException(msg2);
                }
                if (localKeys == null) {
                    messages = context.getAnnotation(Messages.class);
                    if (messages == null) {
                        msg = "When 'property' is empty on @LocalizedProperty, then there must be @Messages besides it to determine the localized properties. " + contextInfo;
                        throw new LocalizationException(msg);
                    }
                    localKeys = new LinkedHashSet<String>();
                    localKeys.addAll(Arrays.asList(messages.keys()));
                    localKeys.addAll(Arrays.asList(messages.value()));
                }
                for (String localKey : localKeys) {
                    if (processedProperties.contains(localKey)) continue;
                    String text2 = composite.getTranslation(MessageKeyUtils.getKeyFor(composite.getClass(), (String)field.getName(), (String)localKey), new Object[0]);
                    LocalizationUtils.setLocalizedText(field, fieldObject, localKey, text2, processedProperties);
                }
                continue;
            }
            if (keyForProperty.isEmpty()) {
                if (localKeys == null) {
                    messages = context.getAnnotation(Messages.class);
                    if (messages == null) {
                        msg = "When 'property' is set on @LocalizedProperty and 'key' is empty, then @Messages must be used besides it to declare a message key with the same (local) name as the property." + contextInfo;
                        throw new LocalizationException(msg);
                    }
                    localKeys = new LinkedHashSet();
                    localKeys.addAll(Arrays.asList(messages.keys()));
                    localKeys.addAll(Arrays.asList(messages.value()));
                }
                if (!localKeys.contains(propertyName)) {
                    msg2 = "When 'property' is set on @LocalizedProperty and 'key' is empty, then @Messages must be used besides it to declare a message key with the same (local) name as the property." + contextInfo;
                    throw new LocalizationException(msg2);
                }
                text = composite.getTranslation(MessageKeyUtils.getKeyFor(composite.getClass(), (String)field.getName(), (String)propertyName), new Object[0]);
                LocalizationUtils.setLocalizedText(field, fieldObject, propertyName, text, processedProperties);
                continue;
            }
            text = composite.getTranslation(keyForProperty, new Object[0]);
            LocalizationUtils.setLocalizedText(field, fieldObject, propertyName, text, processedProperties);
        }
    }

    private static void setLocalizedText(Field field, Object component, String propertyName, String localizedText, Set<String> processedProperties) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(component.getClass(), (String)propertyName);
        if (propertyDescriptor == null) {
            String msg = "The object of type %s in field %s#%s does not have the bean property '%s'.";
            msg = String.format(msg, component.getClass().getName(), field.getDeclaringClass().getName(), field.getName(), propertyName);
            throw new LocalizationException(msg);
        }
        Method setter = propertyDescriptor.getWriteMethod();
        if (setter == null) {
            String msg = "The object of type %s in field %s#%s does not have a setter for the bean property '%s'.";
            msg = String.format(msg, component.getClass().getName(), field.getDeclaringClass().getName(), field.getName(), propertyName);
            throw new LocalizationException(msg);
        }
        setter.invoke(component, localizedText);
        processedProperties.add(propertyName);
    }

    public static MessageAccessor getL10n() {
        UI ui = Objects.requireNonNull(UI.getCurrent(), "No current UI found.");
        return (MessageAccessor)Instantiator.get((UI)ui).getOrCreate(VaadinMessageAccessor.class);
    }
}

