/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public class SessionLocaleUtils {
    public static Locale getSessionLocale() {
        VaadinSession session = Objects.requireNonNull(VaadinSession.getCurrent(), "No current VaadinSession found.");
        return SessionLocaleUtils.getSessionLocale(session);
    }

    public static void setSessionLocale(Locale locale) {
        VaadinSession session = Objects.requireNonNull(VaadinSession.getCurrent(), "No current VaadinSession found.");
        SessionLocaleUtils.setSessionLocale(session, locale);
    }

    public static Locale getSessionLocale(VaadinSession session) {
        Objects.requireNonNull(session, "session must not be null");
        AtomicReference localeHolder = new AtomicReference();
        session.access((Command & Serializable)() -> localeHolder.set(session.getLocale()));
        return (Locale)localeHolder.get();
    }

    public static void setSessionLocale(VaadinSession session, Locale locale) {
        Objects.requireNonNull(session, "session must not be null");
        session.access((Command & Serializable)() -> session.setLocale(locale));
    }

    public static TimeZone getSessionTimeZone() {
        VaadinSession session = Objects.requireNonNull(VaadinSession.getCurrent(), "No current VaadinSession found.");
        return SessionLocaleUtils.getSessionTimeZone(session);
    }

    public static void setSessionTimeZone(TimeZone timeZone) {
        VaadinSession session = Objects.requireNonNull(VaadinSession.getCurrent(), "No current VaadinSession found.");
        SessionLocaleUtils.setSessionTimeZone(session, timeZone);
    }

    public static TimeZone getSessionTimeZone(VaadinSession session) {
        Objects.requireNonNull(session, "session must not be null");
        AtomicReference timeZoneHolder = new AtomicReference();
        session.accessSynchronously((Command & Serializable)() -> timeZoneHolder.set((TimeZone)session.getAttribute(TimeZone.class)));
        return (TimeZone)timeZoneHolder.get();
    }

    public static void setSessionTimeZone(VaadinSession session, TimeZone timeZone) {
        Objects.requireNonNull(session, "session must not be null");
        session.access((Command & Serializable)() -> session.setAttribute(TimeZone.class, (Object)timeZone));
    }
}

