/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.context.i18n.LocaleContextHolder;

public class VaadinSessionLocaleServiceInitListener
implements VaadinServiceInitListener {
    public void serviceInit(ServiceInitEvent serviceInitEvent) {
        serviceInitEvent.addRequestHandler((RequestHandler & Serializable)(session, request, response) -> {
            session.lock();
            try {
                LocaleContextHolder.setLocale((Locale)session.getLocale());
                LocaleContextHolder.setTimeZone((TimeZone)((TimeZone)session.getAttribute(TimeZone.class)));
            }
            finally {
                session.unlock();
            }
            return false;
        });
        serviceInitEvent.getSource().addUIInitListener((UIInitListener & Serializable)uiInitEvent -> {
            UI ui = uiInitEvent.getUI();
            VaadinSession session = ui.getSession();
            if (session.getAttribute(TimeZone.class) == null) {
                ui.getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                    String timeZoneId = details.getTimeZoneId();
                    if (timeZoneId != null) {
                        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
                        session.setAttribute(TimeZone.class, (Object)timeZone);
                        LocaleContextHolder.setTimeZone((TimeZone)timeZone);
                    }
                });
            }
        });
    }
}

