/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin.security;

import com.vaadin.flow.server.VaadinSession;
import de.codecamp.messages.spring.vaadin.SessionLocaleUtils;
import de.codecamp.messages.spring.vaadin.security.HasLocaleAndTimeZone;
import de.codecamp.messages.spring.vaadin.security.LocaleAndTimeZoneExtractor;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class PostAuthenticationSessionLocaleHandler {
    private LocaleAndTimeZoneExtractor localeAndTimeZoneExtractor;

    public void setLocaleAndTimeZoneExtractor(LocaleAndTimeZoneExtractor localeAndTimeZoneExtractor) {
        this.localeAndTimeZoneExtractor = localeAndTimeZoneExtractor;
    }

    @EventListener(value={AuthenticationSuccessEvent.class, InteractiveAuthenticationSuccessEvent.class})
    public void onAuthenticationSuccess(AbstractAuthenticationEvent event) {
        TimeZone timeZone;
        Locale locale;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        Object principal = event.getAuthentication().getPrincipal();
        if (principal instanceof HasLocaleAndTimeZone) {
            HasLocaleAndTimeZone hasLocaleAndTimeZone = (HasLocaleAndTimeZone)principal;
            locale = hasLocaleAndTimeZone.getLocale().orElse(null);
            timeZone = hasLocaleAndTimeZone.getTimeZone().orElse(null);
        } else if (this.localeAndTimeZoneExtractor != null) {
            locale = this.localeAndTimeZoneExtractor.getLocale(event.getAuthentication()).orElse(null);
            timeZone = this.localeAndTimeZoneExtractor.getTimeZone(event.getAuthentication()).orElse(null);
        } else {
            locale = null;
            timeZone = null;
        }
        if (locale == null && timeZone == null) {
            return;
        }
        this.getVaadinSessions(requestAttributes.getRequest()).forEach(session -> {
            if (locale != null) {
                SessionLocaleUtils.setSessionLocale(session, locale);
            }
            if (timeZone != null) {
                SessionLocaleUtils.setSessionTimeZone(session, timeZone);
            }
        });
    }

    private Stream<VaadinSession> getVaadinSessions(HttpServletRequest request) {
        HttpSession httpSession = request.getSession(false);
        if (httpSession == null) {
            return Stream.empty();
        }
        return VaadinSession.getAllSessions((HttpSession)httpSession).stream();
    }
}

